/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayHttpBasic;
import com.github.xiaoymin.knife4j.spring.gateway.conf.GlobalConstants;
import com.github.xiaoymin.knife4j.spring.gateway.enums.GatewayStrategy;
import com.github.xiaoymin.knife4j.spring.gateway.enums.GroupOrderStrategy;
import com.github.xiaoymin.knife4j.spring.gateway.enums.OpenApiVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="knife4j.gateway")
public class Knife4jGatewayProperties {
    private boolean enabled = false;
    private Knife4jGatewayHttpBasic basic;
    private GatewayStrategy strategy = GatewayStrategy.MANUAL;
    private GroupOrderStrategy tagsSorter = GroupOrderStrategy.alpha;
    private GroupOrderStrategy operationsSorter = GroupOrderStrategy.alpha;
    private final Discover discover = new Discover();
    private final List<Router> routes = new ArrayList<Router>();

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Knife4jGatewayHttpBasic getBasic() {
        return this.basic;
    }

    @Generated
    public GatewayStrategy getStrategy() {
        return this.strategy;
    }

    @Generated
    public GroupOrderStrategy getTagsSorter() {
        return this.tagsSorter;
    }

    @Generated
    public GroupOrderStrategy getOperationsSorter() {
        return this.operationsSorter;
    }

    @Generated
    public Discover getDiscover() {
        return this.discover;
    }

    @Generated
    public List<Router> getRoutes() {
        return this.routes;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setBasic(Knife4jGatewayHttpBasic basic) {
        this.basic = basic;
    }

    @Generated
    public void setStrategy(GatewayStrategy strategy) {
        this.strategy = strategy;
    }

    @Generated
    public void setTagsSorter(GroupOrderStrategy tagsSorter) {
        this.tagsSorter = tagsSorter;
    }

    @Generated
    public void setOperationsSorter(GroupOrderStrategy operationsSorter) {
        this.operationsSorter = operationsSorter;
    }

    public static class Discover {
        private Boolean enabled = Boolean.FALSE;
        private Set<String> excludedServices = new HashSet<String>();
        private OpenApiVersion version = OpenApiVersion.OpenAPI3;
        private final OpenApiV3 oas3 = new OpenApiV3();
        private final OpenApiV2 swagger2 = new OpenApiV2();
        private final Map<String, ServiceConfigInfo> serviceConfig = new HashMap<String, ServiceConfigInfo>();

        public String getUrl() {
            if (this.version == OpenApiVersion.OpenAPI3) {
                return this.oas3.getUrl();
            }
            if (this.version == OpenApiVersion.Swagger2) {
                return this.swagger2.getUrl();
            }
            return "/v2/api-docs?group=default";
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Set<String> getExcludedServices() {
            return this.excludedServices;
        }

        @Generated
        public OpenApiVersion getVersion() {
            return this.version;
        }

        @Generated
        public OpenApiV3 getOas3() {
            return this.oas3;
        }

        @Generated
        public OpenApiV2 getSwagger2() {
            return this.swagger2;
        }

        @Generated
        public Map<String, ServiceConfigInfo> getServiceConfig() {
            return this.serviceConfig;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setExcludedServices(Set<String> excludedServices) {
            this.excludedServices = excludedServices;
        }

        @Generated
        public void setVersion(OpenApiVersion version) {
            this.version = version;
        }
    }

    public static class OpenApiV3 {
        private String url = "/v3/api-docs";
        private String oauth2RedirectUrl = "";
        private String validatorUrl = "";

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getOauth2RedirectUrl() {
            return this.oauth2RedirectUrl;
        }

        @Generated
        public String getValidatorUrl() {
            return this.validatorUrl;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setOauth2RedirectUrl(String oauth2RedirectUrl) {
            this.oauth2RedirectUrl = oauth2RedirectUrl;
        }

        @Generated
        public void setValidatorUrl(String validatorUrl) {
            this.validatorUrl = validatorUrl;
        }
    }

    public static class OpenApiV2 {
        private String url = "/v2/api-docs?group=default";

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class Router {
        private String name;
        private String serviceName;
        private String url = "/v2/api-docs?group=default";
        private String contextPath = "/";
        private Integer order = GlobalConstants.DEFAULT_ORDER;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getServiceName() {
            return this.serviceName;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getContextPath() {
            return this.contextPath;
        }

        @Generated
        public Integer getOrder() {
            return this.order;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }

        @Generated
        public void setOrder(Integer order) {
            this.order = order;
        }
    }

    public static class ServiceConfigInfo {
        private Integer order = GlobalConstants.DEFAULT_ORDER;
        private String groupName;
        private List<String> groupNames;
        private String contextPath;

        @Generated
        public Integer getOrder() {
            return this.order;
        }

        @Generated
        public String getGroupName() {
            return this.groupName;
        }

        @Generated
        public List<String> getGroupNames() {
            return this.groupNames;
        }

        @Generated
        public String getContextPath() {
            return this.contextPath;
        }

        @Generated
        public void setOrder(Integer order) {
            this.order = order;
        }

        @Generated
        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Generated
        public void setGroupNames(List<String> groupNames) {
            this.groupNames = groupNames;
        }

        @Generated
        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }
    }
}

