/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayHttpBasic;
import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceChangeListener;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceDiscoverHandler;
import com.github.xiaoymin.knife4j.spring.gateway.discover.router.ConfigRouteServiceConvert;
import com.github.xiaoymin.knife4j.spring.gateway.discover.router.CustomerServiceConvert;
import com.github.xiaoymin.knife4j.spring.gateway.discover.router.DiscoverClientRouteServiceConvert;
import com.github.xiaoymin.knife4j.spring.gateway.discover.router.DynamicRouteServiceConvert;
import com.github.xiaoymin.knife4j.spring.gateway.discover.spi.GatewayServiceExcludeService;
import com.github.xiaoymin.knife4j.spring.gateway.discover.spi.impl.DefaultGatewayServiceExcludeService;
import com.github.xiaoymin.knife4j.spring.gateway.filter.basic.WebFluxSecurityBasicAuthFilter;
import com.github.xiaoymin.knife4j.spring.gateway.utils.EnvironmentUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.discovery.DiscoveryClientRouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={Knife4jGatewayProperties.class, Knife4jGatewayHttpBasic.class})
@ComponentScan(basePackageClasses={Knife4jGatewayAutoConfiguration.class})
@ConditionalOnProperty(name={"knife4j.gateway.enabled"}, havingValue="true")
public class Knife4jGatewayAutoConfiguration {
    private final Environment environment;

    public Knife4jGatewayAutoConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean(value={WebFluxSecurityBasicAuthFilter.class})
    @ConditionalOnProperty(name={"knife4j.gateway.basic.enable"}, havingValue="true")
    public WebFluxSecurityBasicAuthFilter securityBasicAuthFilter(Knife4jGatewayProperties knife4jGatewayProperties) {
        WebFluxSecurityBasicAuthFilter authFilter = new WebFluxSecurityBasicAuthFilter();
        if (knife4jGatewayProperties == null) {
            authFilter.setEnableBasicAuth(EnvironmentUtils.resolveBool(this.environment, "knife4j.gateway.basic.enable", Boolean.FALSE));
            authFilter.setUserName(EnvironmentUtils.resolveString(this.environment, "knife4j.gateway.basic.username", "admin"));
            authFilter.setPassword(EnvironmentUtils.resolveString(this.environment, "knife4j.gateway.basic.password", "123321"));
        } else if (knife4jGatewayProperties.getBasic() == null) {
            authFilter.setEnableBasicAuth(Boolean.FALSE);
            authFilter.setUserName("admin");
            authFilter.setPassword("123321");
        } else {
            authFilter.setEnableBasicAuth(knife4jGatewayProperties.getBasic().isEnable());
            authFilter.setUserName(knife4jGatewayProperties.getBasic().getUsername());
            authFilter.setPassword(knife4jGatewayProperties.getBasic().getPassword());
            authFilter.addRule(knife4jGatewayProperties.getBasic().getInclude());
        }
        return authFilter;
    }

    @Configuration
    @EnableConfigurationProperties(value={Knife4jGatewayProperties.class})
    @ConditionalOnProperty(name={"knife4j.gateway.strategy"}, havingValue="discover")
    public static class Knife4jDiscoverConfiguration {
        @Bean
        public ConfigRouteServiceConvert configRouteServiceConvert(GatewayProperties gatewayProperties, Knife4jGatewayProperties knife4jGatewayProperties) {
            return new ConfigRouteServiceConvert(gatewayProperties, knife4jGatewayProperties);
        }

        @Bean
        public DynamicRouteServiceConvert dynamicRouteServiceConvert(RouteDefinitionRepository routeDefinitionRepository, Knife4jGatewayProperties knife4jGatewayProperties) {
            return new DynamicRouteServiceConvert(routeDefinitionRepository, knife4jGatewayProperties);
        }

        @Bean
        public CustomerServiceConvert customerServiceConvert(Knife4jGatewayProperties knife4jGatewayProperties) {
            return new CustomerServiceConvert(knife4jGatewayProperties);
        }

        @Bean(value={"defaultGatewayServiceExcludeService"})
        public GatewayServiceExcludeService defaultGatewayServiceExcludeService() {
            return new DefaultGatewayServiceExcludeService();
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceDiscoverHandler serviceDiscoverHandler(Knife4jGatewayProperties knife4jGatewayProperties) {
            return new ServiceDiscoverHandler(knife4jGatewayProperties);
        }

        @Bean
        public ServiceChangeListener serviceChangeListener(DiscoveryClient discoveryClient, ServiceDiscoverHandler serviceDiscoverHandler, Knife4jGatewayProperties knife4jGatewayProperties) {
            return new ServiceChangeListener(discoveryClient, serviceDiscoverHandler, knife4jGatewayProperties);
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(value={"spring.cloud.discovery.reactive.enabled"}, matchIfMissing=true)
        public static class ReactiveDiscoveryClientRouteDefinitionLocatorConfiguration {
            @Bean
            @ConditionalOnMissingBean(value={DiscoverClientRouteServiceConvert.class})
            @ConditionalOnProperty(name={"spring.cloud.gateway.discovery.locator.enabled"})
            public DiscoverClientRouteServiceConvert discoverClientRouteServiceConvert(DiscoveryClientRouteDefinitionLocator discoveryClient, Knife4jGatewayProperties knife4jGatewayProperties) {
                return new DiscoverClientRouteServiceConvert(discoveryClient, knife4jGatewayProperties);
            }
        }
    }
}

