/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.utils;

import com.github.xiaoymin.knife4j.spring.gateway.utils.StrUtil;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;

public class PathUtils {
    private static final Logger log = LoggerFactory.getLogger(PathUtils.class);
    static final String DOC_URL = "/doc.html";
    public static final String DEFAULT_CONTEXT_PATH = "/";
    static final Pattern PATTERN = Pattern.compile("(.*?)\\/doc\\.html", 2);

    public static String getContextPath(String referer) {
        if (StringUtils.hasLength((String)referer)) {
            try {
                URI uri = URI.create(referer);
                String path = uri.getPath();
                Matcher mather = PATTERN.matcher(path);
                if (mather.find()) {
                    return mather.group(1);
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return DEFAULT_CONTEXT_PATH;
    }

    public static String append(String ... paths) {
        if (Objects.isNull(paths) || paths.length == 0) {
            return DEFAULT_CONTEXT_PATH;
        }
        String fullPath = Arrays.stream(paths).filter(StringUtils::hasLength).map(path -> DEFAULT_CONTEXT_PATH + path).collect(Collectors.joining());
        return fullPath.replaceAll("/+", DEFAULT_CONTEXT_PATH);
    }

    public static String getDefaultContextPath(ServerHttpRequest request) {
        String contextPath = request.getPath().contextPath().value();
        if (!StringUtils.hasLength((String)contextPath)) {
            List referer = request.getHeaders().get((Object)"Referer");
            if (referer != null && !referer.isEmpty()) {
                String value = (String)referer.get(0);
                log.debug("Referer:{}", (Object)value);
                contextPath = PathUtils.getContextPath(value);
            } else {
                contextPath = DEFAULT_CONTEXT_PATH;
            }
        }
        return contextPath;
    }

    public static String processContextPath(String contextPath) {
        String validateContextPath = contextPath;
        if (DEFAULT_CONTEXT_PATH.equals(validateContextPath)) {
            validateContextPath = "";
        }
        if (validateContextPath.endsWith(DEFAULT_CONTEXT_PATH)) {
            validateContextPath = validateContextPath.substring(0, validateContextPath.length() - 1);
        }
        return validateContextPath;
    }

    public static boolean contextPathNull(String contextPath) {
        return StrUtil.isNotBlank(contextPath) && !contextPath.equalsIgnoreCase(DEFAULT_CONTEXT_PATH);
    }

    private PathUtils() {
    }
}

