/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.discovery.configuration;

import com.github.xiaoymin.knife4j.discovery.configuration.Knife4jCloudDiscoveryInfo;
import com.github.xiaoymin.knife4j.discovery.configuration.Knife4jCloudDiscoveryProperties;
import com.github.xiaoymin.knife4j.discovery.configuration.Knife4jCloudRoute;
import io.swagger.models.Swagger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

public class Knife4jCloudDiscoveryBootstrapper
implements CommandLineRunner,
InitializingBean,
BeanFactoryAware,
EnvironmentAware {
    Logger logger = LoggerFactory.getLogger(Knife4jCloudDiscoveryBootstrapper.class);
    private BeanFactory beanFactory;
    private Environment environment;
    private Knife4jCloudDiscoveryProperties knife4jCloudDiscoveryProperties;
    private static final String SWAGGER_PATH = "/v2/api-docs";
    private static final String KNIFE4J_CLOUD_API = "/knife4j/cloud/upload";

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234;
    }

    public boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (this.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isNotBlank(CharSequence str) {
        return false == this.isBlank(str);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void run(String ... args) throws Exception {
        this.logger.info("Knife4jCloudDiscovery Start...");
        try {
            Map alldoc;
            String contextPath = "";
            String v1BasePath = this.environment.getProperty("server.context-path");
            String basePath = this.environment.getProperty("server.servlet.context-path");
            if (this.isNotBlank(v1BasePath) && !"/".equals(v1BasePath)) {
                contextPath = v1BasePath;
            } else if (this.isNotBlank(basePath) && !"/".equals(basePath)) {
                contextPath = basePath;
            }
            DocumentationCache documentationCache = (DocumentationCache)this.beanFactory.getBean(DocumentationCache.class);
            if (documentationCache != null && (alldoc = documentationCache.all()) != null && alldoc.size() > 0) {
                ServiceModelToSwagger2Mapper swagger2Mapper = (ServiceModelToSwagger2Mapper)this.beanFactory.getBean(ServiceModelToSwagger2Mapper.class);
                JsonSerializer jsonSerializer = (JsonSerializer)this.beanFactory.getBean(JsonSerializer.class);
                Knife4jCloudDiscoveryInfo knife4jCloudDiscoveryInfo = new Knife4jCloudDiscoveryInfo();
                knife4jCloudDiscoveryInfo.setApplicationHost(InetAddress.getLocalHost().getHostAddress());
                knife4jCloudDiscoveryInfo.setApplicationPort(this.environment.getProperty("server.port"));
                knife4jCloudDiscoveryInfo.setSsl(this.knife4jCloudDiscoveryProperties.isSsl());
                knife4jCloudDiscoveryInfo.setClient(this.knife4jCloudDiscoveryProperties.getClient());
                knife4jCloudDiscoveryInfo.setAccessKey(this.knife4jCloudDiscoveryProperties.getAccessKey());
                knife4jCloudDiscoveryInfo.setCode(this.knife4jCloudDiscoveryProperties.getCode());
                ArrayList<Knife4jCloudRoute> knife4jCloudRoutes = new ArrayList<Knife4jCloudRoute>();
                for (Map.Entry entry : alldoc.entrySet()) {
                    if (!this.isNotBlank((CharSequence)entry.getKey())) continue;
                    Knife4jCloudRoute knife4jCloudRoute = new Knife4jCloudRoute();
                    String path = contextPath + SWAGGER_PATH + "?group=" + (String)entry.getKey();
                    Swagger swagger = swagger2Mapper.mapDocumentation((Documentation)entry.getValue());
                    String content = jsonSerializer.toJson((Object)swagger).value();
                    knife4jCloudRoute.setGroupName((String)entry.getKey());
                    knife4jCloudRoute.setPath(path);
                    knife4jCloudRoute.setContent(content);
                    knife4jCloudRoutes.add(knife4jCloudRoute);
                }
                knife4jCloudDiscoveryInfo.setCloudRoutes(knife4jCloudRoutes);
                this.upload(knife4jCloudDiscoveryInfo, jsonSerializer);
            }
        }
        catch (Exception e) {
            this.logger.error("Knife4jCloud Register Failed,Message:{}", (Object)e.getMessage());
        }
    }

    private void upload(Knife4jCloudDiscoveryInfo knife4jCloudDiscoveryInfo, JsonSerializer jsonSerializer) throws IOException {
        if (knife4jCloudDiscoveryInfo.getCloudRoutes() != null && knife4jCloudDiscoveryInfo.getCloudRoutes().size() > 0) {
            String cloudApi = this.knife4jCloudDiscoveryProperties.getServer() + KNIFE4J_CLOUD_API;
            HttpPost post = new HttpPost(cloudApi);
            post.addHeader("Content-Type", "application/json");
            post.setEntity((HttpEntity)new StringEntity(jsonSerializer.toJson((Object)knife4jCloudDiscoveryInfo).value(), "UTF-8"));
            CloseableHttpResponse closeableHttpResponse = HttpClients.createDefault().execute((HttpUriRequest)post);
            if (closeableHttpResponse != null) {
                int status = closeableHttpResponse.getStatusLine().getStatusCode();
                if (status == 200) {
                    String content = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8");
                    this.logger.info("Knife4jCloud Register Result:{}", (Object)content);
                } else {
                    this.logger.info("Knife4jCloud Register Failed,HTTP Status:{}", (Object)status);
                }
                closeableHttpResponse.close();
            }
            this.logger.info("Register To Knife4jCloud Finished");
        } else {
            this.logger.error("No Found Swagger Information");
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.logger.info("Knife4jCloudProperties afterPropertiesSet start");
        this.knife4jCloudDiscoveryProperties = new Knife4jCloudDiscoveryProperties();
        this.knife4jCloudDiscoveryProperties.setServer(this.environment.getProperty("knife4j.cloud.server"));
        this.knife4jCloudDiscoveryProperties.setClient(this.environment.getProperty("knife4j.cloud.client"));
        this.knife4jCloudDiscoveryProperties.setAccessKey(this.environment.getProperty("knife4j.cloud.accessKey"));
        this.knife4jCloudDiscoveryProperties.setCode(this.environment.getProperty("knife4j.cloud.code"));
        String ssl = this.environment.getProperty("knife4j.cloud.ssl");
        if (this.isNotBlank(ssl)) {
            this.knife4jCloudDiscoveryProperties.setSsl(Boolean.valueOf(ssl));
        } else {
            this.knife4jCloudDiscoveryProperties.setSsl(false);
        }
        this.logger.info("Knife4jCloudProperties afterPropertiesSet finished");
    }
}

