/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.spring.support;

import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.github.xiaoymin.knife4j.aggre.polaris.PolarisOpenApi;
import com.github.xiaoymin.knife4j.aggre.polaris.PolarisRoute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="knife4j.polaris")
public class PolarisSetting {
    Logger logger = LoggerFactory.getLogger(PolarisSetting.class);
    private boolean enable;
    private String serviceUrl;
    private BasicAuth serviceAuth;
    private String jwtCookie;
    private List<PolarisRoute> routes;
    private BasicAuth routeAuth;

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public BasicAuth getServiceAuth() {
        return this.serviceAuth;
    }

    public void setServiceAuth(BasicAuth serviceAuth) {
        this.serviceAuth = serviceAuth;
    }

    public String getJwtCookie() {
        return this.jwtCookie;
    }

    public void setJwtCookie(String jwtCookie) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Polaris JwtCookie update: {}", (Object)jwtCookie);
        }
        this.jwtCookie = jwtCookie;
    }

    public List<PolarisRoute> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<PolarisRoute> routes) {
        this.routes = routes;
    }

    public BasicAuth getRouteAuth() {
        return this.routeAuth;
    }

    public void setRouteAuth(BasicAuth routeAuth) {
        this.routeAuth = routeAuth;
    }

    public void initJwtCookie() {
        if (this.serviceAuth != null && this.serviceAuth.isEnable()) {
            this.setJwtCookie(PolarisOpenApi.me().getJwtCookie(this.serviceUrl, this.serviceAuth));
        }
    }
}

