/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.repository;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.cloud.CloudRoute;
import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.github.xiaoymin.knife4j.aggre.core.pojo.CommonRoute;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import com.github.xiaoymin.knife4j.aggre.repository.AbstractRepository;
import com.github.xiaoymin.knife4j.aggre.spring.support.CloudSetting;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudRepository
extends AbstractRepository {
    final Logger logger = LoggerFactory.getLogger(CloudRepository.class);
    private volatile boolean stop = false;
    private Thread thread;
    private CloudSetting cloudSetting;

    public CloudRepository(CloudSetting cloudSetting) {
        this.cloudSetting = cloudSetting;
        if (cloudSetting != null && CollectionUtil.isNotEmpty(cloudSetting.getRoutes())) {
            cloudSetting.getRoutes().stream().forEach(cloudRoute -> {
                if (cloudRoute.getRouteAuth() == null || !cloudRoute.getRouteAuth().isEnable()) {
                    cloudRoute.setRouteAuth(cloudSetting.getRouteAuth());
                }
                this.routeMap.put(cloudRoute.pkId(), new SwaggerRoute((CloudRoute)cloudRoute));
            });
        }
    }

    @Override
    public BasicAuth getAuth(String header) {
        BasicAuth basicAuth = null;
        if (this.cloudSetting != null && CollectionUtil.isNotEmpty(this.cloudSetting.getRoutes())) {
            if (this.cloudSetting.getRouteAuth() != null && this.cloudSetting.getRouteAuth().isEnable()) {
                basicAuth = this.cloudSetting.getRouteAuth();
                BasicAuth routeBasicAuth = this.getAuthByRoute(header, this.cloudSetting.getRoutes());
                if (routeBasicAuth != null) {
                    basicAuth = routeBasicAuth;
                }
            } else {
                basicAuth = this.getAuthByRoute(header, this.cloudSetting.getRoutes());
            }
        }
        return basicAuth;
    }

    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    @Override
    public void start() {
        this.logger.info("start Cloud hearbeat Holder thread.");
        this.thread = new Thread(() -> {
            while (!this.stop) {
                try {
                    this.logger.debug("Cloud hearbeat start working...");
                    if (this.cloudSetting != null && CollectionUtil.isNotEmpty(this.cloudSetting.getRoutes())) {
                        this.cloudSetting.getRoutes().forEach(cloudRoute -> {
                            block12: {
                                String uri = cloudRoute.getUri();
                                String health = cloudRoute.getHealth();
                                StringBuilder urlBuilder = new StringBuilder();
                                if (!StrUtil.startWith((CharSequence)uri, (CharSequence)"http")) {
                                    urlBuilder.append("http://");
                                }
                                urlBuilder.append(uri);
                                if (StrUtil.isNotBlank((CharSequence)health)) {
                                    urlBuilder.append(StrUtil.startWith((CharSequence)health, (CharSequence)"/") ? health : "/" + health);
                                }
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("hearbeat url:{}", (Object)urlBuilder.toString());
                                }
                                HttpGet get = new HttpGet(urlBuilder.toString());
                                try {
                                    CloseableHttpResponse response = this.getClient().execute((HttpUriRequest)get);
                                    if (response != null) {
                                        int statusCode = response.getStatusLine().getStatusCode();
                                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                                        if (this.logger.isDebugEnabled()) {
                                            this.logger.debug("statusCode:{}", (Object)statusCode);
                                        }
                                        if (statusCode < 0) {
                                            this.routeMap.remove(cloudRoute.pkId());
                                        } else if (!this.routeMap.containsKey(cloudRoute.pkId())) {
                                            if (cloudRoute.getRouteAuth() == null || !cloudRoute.getRouteAuth().isEnable()) {
                                                cloudRoute.setRouteAuth(this.cloudSetting.getRouteAuth());
                                            }
                                            this.routeMap.put(cloudRoute.pkId(), new SwaggerRoute((CloudRoute)cloudRoute));
                                        }
                                    } else {
                                        this.routeMap.remove(cloudRoute.pkId());
                                        get.abort();
                                    }
                                }
                                catch (Exception e) {
                                    this.logger.debug("heartBeat url check error,message:" + e.getMessage(), (Throwable)e);
                                    if (!(e instanceof HttpHostConnectException)) break block12;
                                    this.routeMap.remove(cloudRoute.pkId());
                                }
                            }
                        });
                        List<String> settingRouteIds = this.cloudSetting.getRoutes().stream().map(CommonRoute::pkId).collect(Collectors.toList());
                        this.heartRepeatClear(settingRouteIds);
                    }
                }
                catch (Exception e) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
                ThreadUtil.sleep((Number)HEART_BEAT_DURATION);
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void close() {
        this.logger.info("stop Cloud heartbeat Holder thread.");
        this.stop = true;
        if (this.thread != null) {
            ThreadUtil.interrupt((Thread)this.thread, (boolean)true);
        }
    }
}

