/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.polaris;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.core.ext.PoolingConnectionManager;
import com.github.xiaoymin.knife4j.aggre.polaris.PolarisInstance;
import com.github.xiaoymin.knife4j.aggre.polaris.PolarisRoute;
import com.github.xiaoymin.knife4j.aggre.spring.support.PolarisSetting;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisService
extends PoolingConnectionManager
implements Callable<Optional<PolarisInstance>> {
    Logger logger = LoggerFactory.getLogger(PolarisService.class);
    private static final String POLARIS_INSTANCES_API = "/naming/v1/instances";
    private final PolarisSetting setting;
    private final String serviceUrl;
    private final String jwtCookie;
    private final PolarisRoute route;

    public PolarisService(PolarisSetting setting, String serviceUrl, String jwtCookie, PolarisRoute route) {
        this.setting = setting;
        this.serviceUrl = serviceUrl;
        this.jwtCookie = jwtCookie;
        this.route = route;
    }

    @Override
    public Optional<PolarisInstance> call() throws Exception {
        return this.getPolarisInstance();
    }

    private Optional<PolarisInstance> getPolarisInstance() throws Exception {
        ArrayList<String> params = new ArrayList<String>();
        params.add("namespace=" + this.route.getNamespace());
        params.add("healthy=true");
        params.add("service=" + this.route.getService());
        String parameter = CollectionUtil.join(params, (CharSequence)"&");
        String api = this.serviceUrl + POLARIS_INSTANCES_API + "?" + parameter;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Polaris API:{}", (Object)api);
        }
        HttpGet get = new HttpGet(api);
        get.addHeader("Cookie", this.jwtCookie);
        CloseableHttpResponse response = this.getClient().execute((HttpUriRequest)get);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Polaris Response Status:{}", (Object)statusCode);
            }
            if (statusCode == 200) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                if (StrUtil.isNotBlank((CharSequence)content)) {
                    JsonElement jsonElement;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Response Content:{}", (Object)content);
                    }
                    if ((jsonElement = JsonParser.parseString((String)content)) != null && jsonElement.isJsonObject()) {
                        Type type;
                        List polarisInstances;
                        JsonElement instances;
                        if (jsonElement.getAsJsonObject().get("code").toString().equals("407")) {
                            this.setting.initJwtCookie();
                            this.getPolarisInstance();
                        }
                        if (jsonElement.getAsJsonObject().get("code").toString().equals("200000") && (instances = jsonElement.getAsJsonObject().get("instances")) != null && instances.isJsonArray() && CollectionUtil.isNotEmpty((Collection)(polarisInstances = (List)new Gson().fromJson(instances, type = new TypeToken<List<PolarisInstance>>(){}.getType())))) {
                            PolarisInstance polarisInstance = (PolarisInstance)polarisInstances.stream().findAny().get();
                            polarisInstance.setService(this.route.getService());
                            return Optional.of(polarisInstance);
                        }
                    }
                }
            } else {
                get.abort();
            }
        }
        return Optional.empty();
    }
}

