/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.nacos;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.core.ext.PoolingConnectionManager;
import com.github.xiaoymin.knife4j.aggre.nacos.NacosInstance;
import com.github.xiaoymin.knife4j.aggre.nacos.NacosRoute;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosService
extends PoolingConnectionManager
implements Callable<Optional<NacosInstance>> {
    Logger logger = LoggerFactory.getLogger(NacosService.class);
    private static final String NACOS_INSTANCE_LIST_API = "/v1/ns/instance/list";
    private final String serviceUrl;
    private final String accessToken;
    private final NacosRoute nacosRoute;

    public NacosService(String serviceUrl, String accessToken, NacosRoute nacosRoute) {
        this.serviceUrl = serviceUrl;
        this.accessToken = accessToken;
        this.nacosRoute = nacosRoute;
    }

    @Override
    public Optional<NacosInstance> call() throws Exception {
        ArrayList<String> params = new ArrayList<String>();
        params.add("serviceName=" + this.nacosRoute.getServiceName());
        params.add("healthyOnly=true");
        if (StrUtil.isNotBlank((CharSequence)this.nacosRoute.getGroupName())) {
            params.add("groupName=" + this.nacosRoute.getGroupName());
        }
        if (StrUtil.isNotBlank((CharSequence)this.nacosRoute.getNamespaceId())) {
            params.add("namespaceId=" + this.nacosRoute.getNamespaceId());
        }
        if (StrUtil.isNotBlank((CharSequence)this.nacosRoute.getClusters())) {
            params.add("clusters=" + this.nacosRoute.getClusters());
        }
        if (StrUtil.isNotBlank((CharSequence)this.accessToken)) {
            params.add("accessToken=" + this.accessToken);
        }
        String parameter = CollectionUtil.join(params, (CharSequence)"&");
        String api = this.serviceUrl + NACOS_INSTANCE_LIST_API + "?" + parameter;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Nacos API:{}", (Object)api);
        }
        HttpGet get = new HttpGet(api);
        CloseableHttpResponse response = this.getClient().execute((HttpUriRequest)get);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Nacos Response Status:{}", (Object)statusCode);
            }
            if (statusCode == 200) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                if (StrUtil.isNotBlank((CharSequence)content)) {
                    Type type;
                    List nacosInstances;
                    JsonElement instances;
                    JsonElement jsonElement;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Response Content:{}", (Object)content);
                    }
                    if ((jsonElement = JsonParser.parseString((String)content)) != null && jsonElement.isJsonObject() && (instances = jsonElement.getAsJsonObject().get("hosts")) != null && instances.isJsonArray() && CollectionUtil.isNotEmpty((Collection)(nacosInstances = (List)new Gson().fromJson(instances, type = new TypeToken<List<NacosInstance>>(){}.getType())))) {
                        NacosInstance nacosInstance = (NacosInstance)nacosInstances.stream().findAny().get();
                        nacosInstance.setServiceName(this.nacosRoute.getServiceName());
                        return Optional.of(nacosInstance);
                    }
                }
            } else {
                get.abort();
            }
        }
        return Optional.empty();
    }
}

