/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.core.ext;

import com.github.xiaoymin.knife4j.aggre.spring.configuration.HttpConnectionSetting;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ConnectionSettingHolder {
    private HttpConnectionSetting connectionSetting;
    private volatile RequestConfig defaultRequestConfig;
    private volatile PoolingHttpClientConnectionManager poolingHttpClientConnectionManager;
    public static final ConnectionSettingHolder ME = new ConnectionSettingHolder();

    private ConnectionSettingHolder() {
    }

    public synchronized HttpConnectionSetting getConnectionSetting() {
        if (this.connectionSetting == null) {
            this.connectionSetting = new HttpConnectionSetting();
        }
        return this.connectionSetting;
    }

    public void setConnectionSetting(HttpConnectionSetting connectionSetting) {
        this.connectionSetting = connectionSetting;
    }

    public synchronized RequestConfig getDefaultRequestConfig() {
        if (this.defaultRequestConfig == null) {
            this.defaultRequestConfig = RequestConfig.custom().setSocketTimeout(this.getConnectionSetting().getSocketTimeout()).setConnectTimeout(this.getConnectionSetting().getConnectTimeout()).build();
        }
        return this.defaultRequestConfig;
    }

    public synchronized PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager() {
        if (this.poolingHttpClientConnectionManager == null) {
            this.poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
            this.poolingHttpClientConnectionManager.setMaxTotal(this.getConnectionSetting().getMaxConnectionTotal());
            this.poolingHttpClientConnectionManager.setDefaultMaxPerRoute(this.getConnectionSetting().getMaxPreRoute());
        }
        return this.poolingHttpClientConnectionManager;
    }
}

