/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.core.executor;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.core.RouteResponse;
import com.github.xiaoymin.knife4j.aggre.core.pojo.HeaderWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheClientResponse
implements RouteResponse {
    Logger logger = LoggerFactory.getLogger(ApacheClientResponse.class);
    private final HttpResponse httpResponse;
    private HttpEntity httpEntity;

    public ApacheClientResponse(HttpResponse httpResponse) {
        if (httpResponse == null) {
            throw new IllegalArgumentException("\u54cd\u5e94\u8bf7\u6c42\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.httpResponse = httpResponse;
        if (httpResponse != null) {
            this.httpEntity = httpResponse.getEntity();
        }
    }

    @Override
    public List<HeaderWrapper> getHeaders() {
        Object[] headers = this.httpResponse.getAllHeaders();
        ArrayList<HeaderWrapper> headerWrappers = new ArrayList<HeaderWrapper>();
        if (ArrayUtil.isNotEmpty((Object[])headers)) {
            for (Object header : headers) {
                if (header == null) continue;
                headerWrappers.add(new HeaderWrapper(header.getName(), header.getValue()));
            }
        }
        return headerWrappers;
    }

    @Override
    public boolean success() {
        return true;
    }

    @Override
    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    public String getContentType() {
        Header header;
        if (this.httpEntity != null && (header = this.httpEntity.getContentType()) != null) {
            return header.getValue();
        }
        return "application/json";
    }

    @Override
    public Long getContentLength() {
        if (this.httpEntity != null) {
            return this.httpEntity.getContentLength();
        }
        return -1L;
    }

    @Override
    public Charset getCharsetEncoding() {
        Header header;
        if (this.httpEntity != null && (header = this.httpEntity.getContentEncoding()) != null && StrUtil.isNotBlank((CharSequence)header.getValue())) {
            return Charset.forName(header.getValue());
        }
        return Charset.forName("UTF-8");
    }

    @Override
    public InputStream getBody() {
        try {
            return this.httpEntity != null ? this.httpEntity.getContent() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String text() {
        try {
            return EntityUtils.toString((HttpEntity)this.httpEntity, (Charset)this.getCharsetEncoding());
        }
        catch (IOException e) {
            this.logger.error("transform text error:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

