/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.core.pojo;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.cloud.CloudRoute;
import com.github.xiaoymin.knife4j.aggre.disk.DiskRoute;
import com.github.xiaoymin.knife4j.aggre.eureka.EurekaInstance;
import com.github.xiaoymin.knife4j.aggre.eureka.EurekaRoute;
import com.github.xiaoymin.knife4j.aggre.nacos.NacosInstance;
import com.github.xiaoymin.knife4j.aggre.nacos.NacosRoute;
import java.util.Objects;

public class SwaggerRoute {
    private String name;
    private transient String uri;
    private String header;
    private String basicAuth;
    private String location;
    private transient String content;
    private String swaggerVersion;
    private String servicePath;
    private boolean debug = true;
    private boolean local = false;

    public SwaggerRoute(DiskRoute diskRoute, String content) {
        if (diskRoute != null && StrUtil.isNotBlank((CharSequence)content)) {
            this.name = diskRoute.getName();
            if (StrUtil.isNotBlank((CharSequence)diskRoute.getServicePath()) && !StrUtil.equals((CharSequence)diskRoute.getServicePath(), (CharSequence)"/")) {
                this.servicePath = !StrUtil.startWith((CharSequence)diskRoute.getServicePath(), (CharSequence)"/") ? "/" + diskRoute.getServicePath() : diskRoute.getServicePath();
            }
            this.location = "/swagger-instance?group=" + diskRoute.pkId();
            this.content = content;
            this.debug = false;
            this.swaggerVersion = diskRoute.getSwaggerVersion();
        }
    }

    public SwaggerRoute(CloudRoute cloudRoute) {
        if (cloudRoute != null) {
            this.header = cloudRoute.pkId();
            if (cloudRoute.getRouteAuth() != null && cloudRoute.getRouteAuth().isEnable()) {
                this.basicAuth = cloudRoute.pkId();
            }
            this.name = cloudRoute.getName();
            if (StrUtil.isNotBlank((CharSequence)cloudRoute.getUri())) {
                this.uri = !ReUtil.isMatch((String)"(http|https)://.*?$", (CharSequence)cloudRoute.getUri()) ? "http://" + cloudRoute.getUri() : cloudRoute.getUri();
            }
            if (StrUtil.isNotBlank((CharSequence)cloudRoute.getServicePath()) && !StrUtil.equals((CharSequence)cloudRoute.getServicePath(), (CharSequence)"/")) {
                this.servicePath = !StrUtil.startWith((CharSequence)cloudRoute.getServicePath(), (CharSequence)"/") ? "/" + cloudRoute.getServicePath() : cloudRoute.getServicePath();
            }
            this.location = cloudRoute.getLocation();
            this.swaggerVersion = cloudRoute.getSwaggerVersion();
        }
    }

    public SwaggerRoute(EurekaRoute eurekaRoute, EurekaInstance eurekaInstance) {
        if (eurekaRoute != null && eurekaInstance != null) {
            this.header = eurekaRoute.pkId();
            if (eurekaRoute.getRouteAuth() != null && eurekaRoute.getRouteAuth().isEnable()) {
                this.basicAuth = eurekaRoute.pkId();
            }
            this.name = eurekaRoute.getServiceName();
            if (StrUtil.isNotBlank((CharSequence)eurekaRoute.getName())) {
                this.name = eurekaRoute.getName();
            }
            this.uri = "http://" + eurekaInstance.getIpAddr() + ":" + NumberUtil.parseInt((String)Objects.toString(eurekaInstance.getPort().get("$"), "80"));
            if (StrUtil.isNotBlank((CharSequence)eurekaRoute.getServicePath()) && !StrUtil.equals((CharSequence)eurekaRoute.getServicePath(), (CharSequence)"/")) {
                this.servicePath = !StrUtil.startWith((CharSequence)eurekaRoute.getServicePath(), (CharSequence)"/") ? "/" + eurekaRoute.getServicePath() : eurekaRoute.getServicePath();
            }
            this.location = eurekaRoute.getLocation();
            this.swaggerVersion = eurekaRoute.getSwaggerVersion();
        }
    }

    public SwaggerRoute(NacosRoute nacosRoute, NacosInstance nacosInstance) {
        if (nacosRoute != null && nacosInstance != null) {
            this.header = nacosRoute.pkId();
            if (nacosRoute.getRouteAuth() != null && nacosRoute.getRouteAuth().isEnable()) {
                this.basicAuth = nacosRoute.pkId();
            }
            this.name = nacosRoute.getServiceName();
            if (StrUtil.isNotBlank((CharSequence)nacosRoute.getName())) {
                this.name = nacosRoute.getName();
            }
            this.uri = "http://" + nacosInstance.getIp() + ":" + nacosInstance.getPort();
            if (StrUtil.isNotBlank((CharSequence)nacosRoute.getServicePath()) && !StrUtil.equals((CharSequence)nacosRoute.getServicePath(), (CharSequence)"/")) {
                this.servicePath = !StrUtil.startWith((CharSequence)nacosRoute.getServicePath(), (CharSequence)"/") ? "/" + nacosRoute.getServicePath() : nacosRoute.getServicePath();
            }
            this.location = nacosRoute.getLocation();
            this.swaggerVersion = nacosRoute.getSwaggerVersion();
        }
    }

    public String getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(String basicAuth) {
        this.basicAuth = basicAuth;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public void setSwaggerVersion(String swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }
}

