/*
 * Decompiled with CFR 0.152.
 */
package com.ace.cache.rest;

import com.ace.cache.service.ICacheManager;
import com.ace.cache.utils.TreeUtils;
import com.ace.cache.vo.CacheTree;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"cache"})
public class CacheRest {
    @Autowired
    private ICacheManager cacheManager;

    @RequestMapping(value={"/list"})
    @ResponseBody
    public List<CacheTree> listAll() {
        return TreeUtils.buildTree(this.cacheManager.getAll());
    }

    @RequestMapping(path={"/pre/{pre:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CacheTree> listPre(@PathVariable(value="pre") String pre) {
        return TreeUtils.buildTree(this.cacheManager.getByPre(pre));
    }

    @RequestMapping(path={"/{key:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public String get(@PathVariable(value="key") String key) {
        return this.cacheManager.get(key);
    }

    @RequestMapping(path={"/remove"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeAll() {
        this.cacheManager.removeAll();
    }

    @RequestMapping(path={"/pre/{pre:.*}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removePre(@PathVariable(value="pre") String pre) {
        this.cacheManager.removeByPre(pre);
    }

    @RequestMapping(path={"/{key:.*}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeKey(@PathVariable(value="key") String key) {
        this.cacheManager.remove(key);
    }

    @RequestMapping(path={"/{key:.*}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void updateTime(@PathVariable(value="key") String key, int hour) {
        this.cacheManager.update(key, hour);
    }

    @RequestMapping(value={""})
    public String index() {
        return "/static/cache/index.html";
    }
}

