/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient;

import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.SignatureExec;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.auth.CertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;

public class WechatPayHttpClientBuilder
extends HttpClientBuilder {
    private static final String OS = System.getProperty("os.name") + "/" + System.getProperty("os.version");
    private static final String VERSION = System.getProperty("java.version");
    private Credentials credentials;
    private Validator validator;

    private WechatPayHttpClientBuilder() {
        String userAgent = String.format("WechatPay-Apache-HttpClient/%s (%s) Java/%s", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), OS, VERSION == null ? "Unknown" : VERSION);
        this.setUserAgent(userAgent);
    }

    public static WechatPayHttpClientBuilder create() {
        return new WechatPayHttpClientBuilder();
    }

    public WechatPayHttpClientBuilder withMerchant(String merchantId, String serialNo, PrivateKey privateKey) {
        this.credentials = new WechatPay2Credentials(merchantId, new PrivateKeySigner(serialNo, privateKey));
        return this;
    }

    public WechatPayHttpClientBuilder withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public WechatPayHttpClientBuilder withWechatPay(List<X509Certificate> certificates) {
        this.validator = new WechatPay2Validator(new CertificatesVerifier(certificates));
        return this;
    }

    public WechatPayHttpClientBuilder withProxy(HttpHost proxy) {
        if (proxy != null) {
            this.setProxy(proxy);
        }
        return this;
    }

    @Deprecated
    public WechatPayHttpClientBuilder withWechatpay(List<X509Certificate> certificates) {
        return this.withWechatPay(certificates);
    }

    public WechatPayHttpClientBuilder withValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public CloseableHttpClient build() {
        if (this.credentials == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u8eab\u4efd\u8ba4\u8bc1\u4fe1\u606f");
        }
        if (this.validator == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u7b7e\u540d\u9a8c\u8bc1\u4fe1\u606f");
        }
        return super.build();
    }

    protected ClientExecChain decorateProtocolExec(ClientExecChain requestExecutor) {
        return new SignatureExec(this.credentials, this.validator, requestExecutor);
    }
}

