/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.aop.EncryptableMutablePropertySourcesInterceptor;
import com.ulisesbocchio.jasyptspringboot.aop.EncryptablePropertySourceMethodInterceptor;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableEnumerablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableMapPropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableSystemEnvironmentPropertySourceWrapper;
import java.lang.reflect.Modifier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.env.CommandLinePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.SystemEnvironmentPropertySource;

public class EncryptablePropertySourceConverter {
    private static final Logger log = LoggerFactory.getLogger(EncryptablePropertySourceConverter.class);

    public static void convertPropertySources(InterceptionMode interceptionMode, EncryptablePropertyResolver propertyResolver, EncryptablePropertyFilter propertyFilter, MutablePropertySources propSources) {
        StreamSupport.stream(propSources.spliterator(), false).filter(ps -> !(ps instanceof EncryptablePropertySource)).map(ps -> EncryptablePropertySourceConverter.makeEncryptable(interceptionMode, propertyResolver, propertyFilter, ps)).collect(Collectors.toList()).forEach(ps -> propSources.replace(ps.getName(), ps));
    }

    public static <T> PropertySource<T> makeEncryptable(InterceptionMode interceptionMode, EncryptablePropertyResolver propertyResolver, EncryptablePropertyFilter propertyFilter, PropertySource<T> propertySource) {
        if (propertySource instanceof EncryptablePropertySource) {
            return propertySource;
        }
        PropertySource<T> encryptablePropertySource = EncryptablePropertySourceConverter.convertPropertySource(interceptionMode, propertyResolver, propertyFilter, propertySource);
        log.info("Converting PropertySource {} [{}] to {}", new Object[]{propertySource.getName(), propertySource.getClass().getName(), AopUtils.isAopProxy(encryptablePropertySource) ? "AOP Proxy" : encryptablePropertySource.getClass().getSimpleName()});
        return encryptablePropertySource;
    }

    private static <T> PropertySource<T> convertPropertySource(InterceptionMode interceptionMode, EncryptablePropertyResolver propertyResolver, EncryptablePropertyFilter propertyFilter, PropertySource<T> propertySource) {
        return interceptionMode == InterceptionMode.PROXY ? EncryptablePropertySourceConverter.proxyPropertySource(propertySource, propertyResolver, propertyFilter) : EncryptablePropertySourceConverter.instantiatePropertySource(propertySource, propertyResolver, propertyFilter);
    }

    public static MutablePropertySources proxyPropertySources(InterceptionMode interceptionMode, EncryptablePropertyResolver propertyResolver, EncryptablePropertyFilter propertyFilter, MutablePropertySources propertySources) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget(MutablePropertySources.class);
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.addInterface(PropertySources.class);
        proxyFactory.setTarget((Object)propertySources);
        proxyFactory.addAdvice((Advice)new EncryptableMutablePropertySourcesInterceptor(interceptionMode, propertyResolver, propertyFilter));
        return (MutablePropertySources)proxyFactory.getProxy();
    }

    public static <T> PropertySource<T> proxyPropertySource(PropertySource<T> propertySource, EncryptablePropertyResolver resolver, EncryptablePropertyFilter propertyFilter) {
        if (CommandLinePropertySource.class.isAssignableFrom(propertySource.getClass()) || Modifier.isFinal(propertySource.getClass().getModifiers())) {
            return EncryptablePropertySourceConverter.instantiatePropertySource(propertySource, resolver, propertyFilter);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(propertySource.getClass());
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.addInterface(EncryptablePropertySource.class);
        proxyFactory.setTarget(propertySource);
        proxyFactory.addAdvice(new EncryptablePropertySourceMethodInterceptor<T>(propertySource, resolver, propertyFilter));
        return (PropertySource)proxyFactory.getProxy();
    }

    public static <T> PropertySource<T> instantiatePropertySource(PropertySource<T> propertySource, EncryptablePropertyResolver resolver, EncryptablePropertyFilter propertyFilter) {
        Object encryptablePropertySource = EncryptablePropertySourceConverter.needsProxyAnyway(propertySource) ? EncryptablePropertySourceConverter.proxyPropertySource(propertySource, resolver, propertyFilter) : (propertySource instanceof SystemEnvironmentPropertySource ? new EncryptableSystemEnvironmentPropertySourceWrapper((SystemEnvironmentPropertySource)propertySource, resolver, propertyFilter) : (propertySource instanceof MapPropertySource ? new EncryptableMapPropertySourceWrapper((MapPropertySource)propertySource, resolver, propertyFilter) : (propertySource instanceof EnumerablePropertySource ? new EncryptableEnumerablePropertySourceWrapper((EnumerablePropertySource)propertySource, resolver, propertyFilter) : new EncryptablePropertySourceWrapper<T>(propertySource, resolver, propertyFilter))));
        return encryptablePropertySource;
    }

    private static boolean needsProxyAnyway(PropertySource<?> ps) {
        return EncryptablePropertySourceConverter.needsProxyAnyway(ps.getClass());
    }

    private static boolean needsProxyAnyway(Class<? extends PropertySource<?>> psClass) {
        return EncryptablePropertySourceConverter.needsProxyAnyway(psClass.getName());
    }

    private static boolean needsProxyAnyway(String className) {
        return Stream.of("org.springframework.boot.context.config.ConfigFileApplicationListener$ConfigurationPropertySources", "org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource").anyMatch(className::equals);
    }
}

