/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MathsHelper
extends HandlebarsHelper<Object> {
    public Object apply(Object context, Options options) throws IOException {
        if (options.params.length != 2) {
            return this.handleError("All maths functions require two operands and an operator as parameters e.g. 3 '+' 2");
        }
        BigDecimal left = MathsHelper.coerceToBigDecimal(context);
        String operator = options.params[0].toString();
        BigDecimal right = MathsHelper.coerceToBigDecimal(options.params[1]);
        BigDecimal result = null;
        switch (operator) {
            case "+": {
                result = left.add(right);
                break;
            }
            case "-": {
                result = left.subtract(right);
                break;
            }
            case "*": 
            case "x": {
                result = left.multiply(right);
                break;
            }
            case "/": {
                result = left.divide(right, RoundingMode.HALF_UP);
                break;
            }
            case "%": {
                result = left.remainder(right);
                break;
            }
            default: {
                return this.handleError(operator + " is not a valid mathematical operator");
            }
        }
        return MathsHelper.reduceToPrimitiveNumber(result);
    }

    private static BigDecimal coerceToBigDecimal(Object value) {
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Float) {
            return BigDecimal.valueOf(((Float)value).floatValue());
        }
        if (value instanceof CharSequence) {
            return new BigDecimal(value.toString());
        }
        return new BigDecimal(0);
    }

    private static Object reduceToPrimitiveNumber(BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (value.scale() == 0) {
            if (value.longValue() <= Integer.MAX_VALUE) {
                return value.intValue();
            }
            return value.longValue();
        }
        return value.doubleValue();
    }
}

