/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.xml;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlException
extends InvalidInputException {
    protected XmlException(Errors errors) {
        super(errors);
    }

    protected XmlException(Throwable cause, Errors errors) {
        super(cause, errors);
    }

    public static XmlException fromSaxException(SAXException e) {
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            String detail = String.format("%s; line %d; column %d", spe.getMessage(), spe.getLineNumber(), spe.getColumnNumber());
            return new XmlException(Errors.singleWithDetail(50, e.getMessage(), detail));
        }
        return new XmlException(e, Errors.single(50, e.getMessage()));
    }
}

