/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.internal.JsonJavadocReader;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.Json;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;

public class RuntimeJavadoc {
    private RuntimeJavadoc() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static ClassJavadoc getJavadoc(Class<?> clazz) {
        return RuntimeJavadoc.getSkinnyClassJavadoc(clazz.getName(), clazz).createEnhancedClassJavadoc(clazz);
    }

    public static ClassJavadoc getJavadoc(String qualifiedClassName) {
        return RuntimeJavadoc.getJavadoc(qualifiedClassName, RuntimeJavadoc.class);
    }

    public static ClassJavadoc getJavadoc(String qualifiedClassName, ClassLoader loader) {
        try {
            return RuntimeJavadoc.getSkinnyClassJavadoc(qualifiedClassName, loader).createEnhancedClassJavadoc(loader.loadClass(qualifiedClassName));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassJavadoc getJavadoc(String qualifiedClassName, Class<?> loader) {
        try {
            return RuntimeJavadoc.getSkinnyClassJavadoc(qualifiedClassName, loader).createEnhancedClassJavadoc(loader.getClassLoader().loadClass(qualifiedClassName));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static ClassJavadoc getSkinnyClassJavadoc(Class<?> clazz) {
        return RuntimeJavadoc.getSkinnyClassJavadoc(clazz.getName(), clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassJavadoc getSkinnyClassJavadoc(String qualifiedClassName, ClassLoader loader) {
        String resourceName = RuntimeJavadoc.getResourceName(qualifiedClassName);
        try (InputStream is = loader.getResourceAsStream("/" + resourceName);){
            ClassJavadoc classJavadoc = RuntimeJavadoc.parseJavadocResource(qualifiedClassName, is);
            return classJavadoc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassJavadoc getSkinnyClassJavadoc(String qualifiedClassName, Class<?> loader) {
        String resourceName = RuntimeJavadoc.getResourceName(qualifiedClassName);
        try (InputStream is = loader.getResourceAsStream("/" + resourceName);){
            ClassJavadoc classJavadoc = RuntimeJavadoc.parseJavadocResource(qualifiedClassName, is);
            return classJavadoc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getResourceName(String qualifiedClassName) {
        return qualifiedClassName.replace(".", "/") + RuntimeJavadocHelper.javadocResourceSuffix();
    }

    private static ClassJavadoc parseJavadocResource(String qualifiedClassName, InputStream is) throws IOException {
        if (is == null) {
            return ClassJavadoc.createEmpty(qualifiedClassName);
        }
        try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
            JsonObject json = Json.parse(r).asObject();
            ClassJavadoc classJavadoc = JsonJavadocReader.readClassJavadoc(qualifiedClassName, json);
            return classJavadoc;
        }
    }

    public static MethodJavadoc getJavadoc(Method method) {
        return RuntimeJavadoc.getJavadoc(method, Collections.emptyMap());
    }

    static MethodJavadoc getJavadoc(Method method, Map<String, ClassJavadoc> classJavadocCache) {
        MethodJavadoc methodJavadoc;
        Class<?> declaringClass = method.getDeclaringClass();
        ClassJavadoc classJavadoc = classJavadocCache.get(declaringClass.getCanonicalName());
        if (classJavadoc == null) {
            classJavadoc = RuntimeJavadoc.getSkinnyClassJavadoc(declaringClass);
        }
        if ((methodJavadoc = classJavadoc.findMatchingMethod(method)).fullyDescribes(method)) {
            return methodJavadoc;
        }
        if ((methodJavadoc = methodJavadoc.enhanceWithOverriddenJavadoc(method, classJavadocCache)).fullyDescribes(method)) {
            return methodJavadoc;
        }
        Method bridgeMethod = RuntimeJavadocHelper.findBridgeMethod(method);
        if (bridgeMethod != null && method != bridgeMethod) {
            methodJavadoc = methodJavadoc.enhanceWithOverriddenJavadoc(bridgeMethod, classJavadocCache);
        }
        return methodJavadoc;
    }

    public static MethodJavadoc getJavadoc(Constructor<?> method) {
        return RuntimeJavadoc.getSkinnyClassJavadoc(method.getDeclaringClass()).findMatchingConstructor(method);
    }

    public static FieldJavadoc getJavadoc(Field field) {
        return RuntimeJavadoc.getSkinnyClassJavadoc(field.getDeclaringClass()).findMatchingField(field);
    }

    public static FieldJavadoc getJavadoc(Enum<?> enumValue) {
        return RuntimeJavadoc.getSkinnyClassJavadoc(enumValue.getDeclaringClass()).findMatchingEnumConstant(enumValue);
    }
}

