/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver.function;

import jetbrick.bean.MethodInfo;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.resolver.ParameterUtils;
import jetbrick.template.resolver.function.FunctionInvoker;

final class ExtensionFunctionInvoker
implements FunctionInvoker {
    private final MethodInfo method;
    private final int length;
    private final Class<?> varArgsClass;

    public ExtensionFunctionInvoker(MethodInfo method) {
        this.method = method;
        this.length = method.getParameterCount();
        if (method.isVarArgs()) {
            Class[] types = method.getParameterTypes();
            this.varArgsClass = types[types.length - 1].getComponentType();
        } else {
            this.varArgsClass = null;
        }
    }

    @Override
    public void checkAccess(JetSecurityManager securityManager) {
        securityManager.checkAccess(this.method.getMethod());
    }

    @Override
    public Object invoke(Object[] arguments) {
        arguments = ParameterUtils.getActualArguments(arguments, this.length, this.varArgsClass, 0);
        return this.method.invoke(null, arguments);
    }

    @Override
    public String getSignature() {
        return this.method.getSignature();
    }
}

