/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import java.util.List;
import jetbrick.template.parser.ParserContext;
import jetbrick.template.parser.ast.AstDirective;
import jetbrick.template.parser.ast.AstDirectiveCall;
import jetbrick.template.parser.ast.AstDirectiveInclude;
import jetbrick.template.parser.ast.AstDirectiveNoop;
import jetbrick.template.parser.ast.AstDirectiveTag;
import jetbrick.template.parser.ast.AstNode;
import jetbrick.template.parser.ast.AstStatement;
import jetbrick.template.parser.ast.AstText;
import jetbrick.template.runtime.InterpretContext;

public final class AstStatementList
extends AstStatement {
    private static final AstStatement[] EMPTY_ARRAY = new AstStatement[0];
    private final AstStatement[] statements;

    public AstStatementList(List<AstStatement> statements, int block, ParserContext ctx) {
        if (statements == null || statements.isEmpty()) {
            this.statements = EMPTY_ARRAY;
        } else {
            if (statements.size() > 0 && block != 8) {
                ListIterator<AstStatement> it = new ListIterator<AstStatement>(statements);
                this.splitStatementList(it);
                this.combinedContinuousTexts(it);
                this.trimDirectiveWhitespacesAndComments(it, block, ctx);
                this.removeNoopDirective(it);
                this.combinedContinuousTexts(it);
            }
            this.statements = statements.toArray(EMPTY_ARRAY);
        }
    }

    private void splitStatementList(ListIterator<AstStatement> it) {
        it.reset();
        while (it.has()) {
            AstStatement statment = it.peek();
            if (statment instanceof AstStatementList) {
                it.remove();
                it.addAll((AstStatement[])((AstStatementList)statment).statements);
            }
            it.move();
        }
    }

    private void removeNoopDirective(ListIterator<AstStatement> it) {
        it.reset();
        while (it.has()) {
            if (it.peek() instanceof AstDirectiveNoop) {
                it.remove();
                continue;
            }
            it.move();
        }
    }

    private void combinedContinuousTexts(ListIterator<AstStatement> it) {
        StringBuilder sb = null;
        it.reset();
        while (it.has()) {
            AstStatement stmt = it.peek();
            if (!(stmt instanceof AstText)) {
                it.move();
                continue;
            }
            if (it.hasNext()) {
                AstStatement next = it.peek(1);
                if (!(next instanceof AstText)) {
                    it.move(2);
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder(256);
                } else {
                    sb.setLength(0);
                }
                sb.append(((AstText)stmt).getText());
                it.remove();
                sb.append(((AstText)next).getText());
                it.remove();
                while (it.has() && (next = it.peek()) instanceof AstText) {
                    sb.append(((AstText)next).getText());
                    it.remove();
                }
                it.add(new AstText(sb.toString(), ((AstText)stmt).getLine()));
            }
            it.move();
        }
    }

    private void trimDirectiveWhitespacesAndComments(ListIterator<AstStatement> it, int block, ParserContext ctx) {
        boolean trimDirectiveWhitespaces = ctx.isTrimDirectiveWhitespaces();
        boolean trimDirectiveComments = ctx.isTrimDirectiveComments();
        String trimDirectiveCommentsPrefix = ctx.getTrimDirectiveCommentsPrefix();
        String trimDirectiveCommentsSuffix = ctx.getTrimDirectiveCommentsSuffix();
        if (!trimDirectiveWhitespaces && !trimDirectiveComments) {
            return;
        }
        it.reset();
        while (it.has()) {
            boolean trimCommentsRight;
            boolean trimWhitespacesRight;
            boolean trimCommentsLeft;
            boolean trimWhitespacesLeft;
            AstStatement stmt = it.peek();
            if (!(stmt instanceof AstText)) {
                it.move();
                continue;
            }
            AstText text = (AstText)stmt;
            boolean keepLeftNewLine = false;
            if (it.hasPrevious()) {
                AstStatement prev;
                trimWhitespacesLeft = this.isAstDirective(it.peek(-1), false);
                trimCommentsLeft = this.isAstDirective(it.peek(-1), true);
                if (trimWhitespacesLeft && (prev = it.peek(-1)) != null && prev instanceof AstDirective) {
                    keepLeftNewLine = prev instanceof AstDirectiveTag ? true : ((AstDirective)prev).getPosition().getLine() == text.getLine();
                }
            } else {
                trimCommentsLeft = trimWhitespacesLeft = block != 1;
            }
            if (it.hasNext()) {
                trimWhitespacesRight = this.isAstDirective(it.peek(1), false);
                trimCommentsRight = this.isAstDirective(it.peek(1), true);
            } else {
                trimCommentsRight = trimWhitespacesRight = block != 1;
            }
            if (trimDirectiveComments) {
                text.trimDirectiveComments(trimCommentsLeft, trimCommentsRight, trimDirectiveCommentsPrefix, trimDirectiveCommentsSuffix);
            }
            if (trimDirectiveWhitespaces) {
                text.trimDirectiveWhitespaces(trimWhitespacesLeft, trimWhitespacesRight, keepLeftNewLine);
            }
            if (!(it.hasNext() || block != 7 && block != 6)) {
                text.trimLastNewLine();
            }
            if (text.isEmpty()) {
                it.remove();
                continue;
            }
            it.move();
        }
    }

    private boolean isAstDirective(AstNode node, boolean includeInlineDirective) {
        if (node instanceof AstDirective) {
            if (includeInlineDirective) {
                return true;
            }
            return !(node instanceof AstDirectiveInclude) && !(node instanceof AstDirectiveCall);
        }
        return false;
    }

    @Override
    public void execute(InterpretContext ctx) {
        for (AstStatement stmt : this.statements) {
            stmt.execute(ctx);
            if (ctx.getSignal() == 0) continue;
            return;
        }
    }

    static final class ListIterator<T> {
        private final List<T> list;
        private int index;
        private int size;

        public ListIterator(List<T> list) {
            this.list = list;
            this.index = 0;
            this.size = list.size();
        }

        public boolean has() {
            return this.index >= 0 && this.index < this.size;
        }

        public boolean hasNext() {
            return this.index + 1 < this.size;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public boolean has(int offset) {
            int p = this.index + offset;
            return p >= 0 && p < this.size;
        }

        public void move() {
            ++this.index;
        }

        public void move(int offset) {
            this.index += offset;
        }

        public void reset() {
            this.index = 0;
            this.size = this.list.size();
        }

        public T peek() {
            return this.list.get(this.index);
        }

        public T peek(int offset) {
            return this.list.get(this.index + offset);
        }

        public void remove() {
            this.list.remove(this.index);
            this.size = this.list.size();
        }

        public void add(T item) {
            this.list.add(this.index++, item);
            this.size = this.list.size();
        }

        public void addAll(T[] items) {
            for (T item : items) {
                this.list.add(this.index++, item);
            }
            this.size = this.list.size();
        }
    }
}

