/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.parser.ast.ALU;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;

public final class AstOperatorEquals
extends AstExpression {
    private final int operator;
    private final AstExpression lhs;
    private final AstExpression rhs;

    public AstOperatorEquals(int operator, AstExpression lhs, AstExpression rhs, Position position) {
        super(position);
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        Boolean value;
        Object o1 = this.lhs.execute(ctx);
        switch (this.operator) {
            case 18: {
                value = o1 == this.rhs.execute(ctx);
                break;
            }
            case 19: {
                value = o1 != this.rhs.execute(ctx);
                break;
            }
            case 16: {
                value = ALU.equals(o1, this.rhs.execute(ctx));
                break;
            }
            case 17: {
                value = ALU.equals(o1, this.rhs.execute(ctx)) != false ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 20: {
                value = ALU.isTrue(o1) && ALU.isTrue(this.rhs.execute(ctx)) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 21: {
                value = ALU.isTrue(o1) || ALU.isTrue(this.rhs.execute(ctx)) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 23: {
                value = ALU.isTrue(o1) ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return value;
    }
}

