/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.web.servlet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import jetbrick.util.StringUtils;

public final class RequestDumpUtils {
    public static String dump(HttpServletRequest request) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        String FORMAT = "%20s: %s%n";
        int PADDING_CHAR = 61;
        int PADDING_SIZE = 60;
        out.println(StringUtils.center(" Request Basic ", 60, '='));
        out.printf("%20s: %s%n", "Request Date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z").format(new Date()));
        out.printf("%20s: %s%n", "Request URL", request.getRequestURL());
        out.printf("%20s: %s%n", "QueryString", request.getQueryString());
        out.printf("%20s: %s%n", "Method", request.getMethod());
        out.println();
        out.printf("%20s: %s%n", "CharacterEncoding", request.getCharacterEncoding());
        out.printf("%20s: %s%n", "ContentType", request.getContentType());
        out.printf("%20s: %s%n", "ContentLength", request.getContentLength());
        out.printf("%20s: %s%n", "Locale", request.getLocale());
        out.printf("%20s: %s%n", "RemoteAddr", request.getRemoteAddr());
        out.println();
        out.println(StringUtils.center(" Request Headers ", 60, '='));
        Enumeration header = request.getHeaderNames();
        while (header.hasMoreElements()) {
            String name = (String)header.nextElement();
            String value = request.getHeader(name);
            out.printf("%20s: %s%n", name, value);
        }
        out.println();
        out.println(StringUtils.center(" Request Parameters ", 60, '='));
        Enumeration param = request.getParameterNames();
        while (param.hasMoreElements()) {
            String name = (String)param.nextElement();
            Object[] value = request.getParameterValues(name);
            out.printf("%20s: %s%n", name, StringUtils.join(value, ", "));
        }
        out.println();
        out.println(StringUtils.center(" Request Cookies ", 60, '='));
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                out.printf("%20s: %s%n", cookie.getName(), cookie.getValue());
            }
        }
        out.println();
        out.println(StringUtils.repeat('=', 60));
        out.flush();
        return sw.toString();
    }
}

