/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

public final class FilenameUtils {
    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = FilenameUtils.getFileSeparatorIndex(path);
        return separatorIndex == -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFileExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = FilenameUtils.getFileSeparatorIndex(path);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String getFileBasename(String filename) {
        return FilenameUtils.removeFileExtension(FilenameUtils.getFilename(filename));
    }

    public static String removeFileExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = FilenameUtils.getFileSeparatorIndex(path);
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }

    private static int getFileSeparatorIndex(String path) {
        for (int i = path.length() - 1; i >= 0; --i) {
            char c = path.charAt(i);
            if (c != '/' && c != '\\') continue;
            return i;
        }
        return -1;
    }
}

