/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class LongConvertor
implements Convertor<Long> {
    public static final LongConvertor INSTANCE = new LongConvertor();

    @Override
    public Long convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw TypeCastException.create(value, Long.class, e);
        }
    }

    @Override
    public Long convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Long.class) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return this.convert(value.toString());
    }
}

