/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class FloatConvertor
implements Convertor<Float> {
    public static final FloatConvertor INSTANCE = new FloatConvertor();

    @Override
    public Float convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw TypeCastException.create(value, Float.class, e);
        }
    }

    @Override
    public Float convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Float.class) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return this.convert(value.toString());
    }
}

