/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.math.BigDecimal;
import java.math.BigInteger;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class BigDecimalConvertor
implements Convertor<BigDecimal> {
    public static final BigDecimalConvertor INSTANCE = new BigDecimalConvertor();

    @Override
    public BigDecimal convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw TypeCastException.create(value, BigDecimal.class, e);
        }
    }

    @Override
    public BigDecimal convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        return this.convert(value.toString());
    }
}

