/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import jetbrick.collection.ListUtils;
import jetbrick.typecast.Convertor;
import jetbrick.util.ArrayUtils;
import jetbrick.util.StringUtils;

public final class ArrayConvertor<T>
implements Convertor<T[]> {
    private final Class<T> elementType;
    private final Convertor<T> elementConvertor;

    public ArrayConvertor(Class<T> elementType, Convertor<T> elementConvertor) {
        this.elementType = elementType;
        this.elementConvertor = elementConvertor;
    }

    @Override
    public T[] convert(String value) {
        if (value == null) {
            return null;
        }
        Object[] values = StringUtils.split(value.toString(), ',');
        if (this.elementType == String.class) {
            return values;
        }
        return this.convertToArray(values);
    }

    @Override
    public T[] convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            Object[] arrays = ArrayConvertor.toObjectArray(value);
            if (this.elementType.isAssignableFrom(arrays.getClass().getComponentType())) {
                return arrays;
            }
            return this.convertToArray(arrays);
        }
        if (value instanceof Iterable) {
            List results = ListUtils.asList((Iterable)value);
            return this.convertToArray(results);
        }
        if (value instanceof Iterator) {
            List results = ListUtils.asList((Iterator)value);
            return this.convertToArray(results);
        }
        if (value instanceof Enumeration) {
            List results = ListUtils.asList((Enumeration)value);
            return this.convertToArray(results);
        }
        return this.convert(value.toString());
    }

    private T[] convertToArray(Object[] items) {
        Object[] results = (Object[])Array.newInstance(this.elementType, items.length);
        for (int i = 0; i < items.length; ++i) {
            Object value = items[i];
            results[i] = this.elementType.isInstance(value) ? value : this.elementConvertor.convert(value);
        }
        return results;
    }

    private T[] convertToArray(List items) {
        Object[] results = (Object[])Array.newInstance(this.elementType, items.size());
        int i = 0;
        for (Object item : items) {
            if (this.elementType.isInstance(item)) {
                results[i++] = item;
                continue;
            }
            results[i++] = this.elementConvertor.convert(item);
        }
        return results;
    }

    protected static Object[] toObjectArray(Object value) {
        Class<?> componentType = value.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            if (componentType == Integer.TYPE) {
                return ArrayUtils.toObject((int[])value);
            }
            if (componentType == Long.TYPE) {
                return ArrayUtils.toObject((long[])value);
            }
            if (componentType == Float.TYPE) {
                return ArrayUtils.toObject((float[])value);
            }
            if (componentType == Double.TYPE) {
                return ArrayUtils.toObject((double[])value);
            }
            if (componentType == Boolean.TYPE) {
                return ArrayUtils.toObject((boolean[])value);
            }
            if (componentType == Byte.TYPE) {
                return ArrayUtils.toObject((byte[])value);
            }
            if (componentType == Short.TYPE) {
                return ArrayUtils.toObject((short[])value);
            }
            if (componentType == Character.TYPE) {
                return ArrayUtils.toObject((char[])value);
            }
            throw new IllegalStateException("Unreachable code");
        }
        return (Object[])value;
    }
}

