/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.finder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jetbrick.io.IoUtils;
import jetbrick.io.resource.AbstractResource;
import jetbrick.io.resource.FileSystemResource;
import jetbrick.io.resource.JbossVfsResource;
import jetbrick.io.resource.Resource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.io.resource.ResourceUtils;
import jetbrick.io.resource.ZipEntryResource;
import jetbrick.util.ClassLoaderUtils;
import jetbrick.util.ClasspathUtils;
import jetbrick.util.StringUtils;
import jetbrick.util.Validate;

public abstract class FileFinder {
    public void lookupFileSystem(File dir, boolean recursive) {
        Validate.notNull(dir);
        this.doLookupInFileSystem(dir, null, null, recursive);
    }

    public void lookupClasspath(Collection<String> packageNames, boolean recursive) {
        ClassLoader loader = ClassLoaderUtils.getDefault();
        if (packageNames == null || packageNames.size() == 0) {
            Collection<URL> urls = ClasspathUtils.getClasspathURLs(loader);
            this.doGetClasspathResources(urls, null, recursive);
        } else {
            for (String pkg : packageNames) {
                Collection<URL> urls = ClasspathUtils.getClasspathURLs(loader, pkg);
                this.doGetClasspathResources(urls, pkg, recursive);
            }
        }
    }

    public void lookupZipFile(File zipFile, String entryName, boolean recursive) {
        Validate.notNull(zipFile);
        if (entryName != null) {
            entryName = StringUtils.removeEnd(entryName, "/");
        }
        entryName = StringUtils.trimToEmpty(entryName);
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            this.doLookupInZipFile(zip, entryName, recursive);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(zip);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(zip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetClasspathResources(Collection<URL> urls, String pkg, boolean recursive) {
        for (URL url : urls) {
            AbstractResource resource;
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                String name;
                File file = ResourceUtils.create(url).getFile();
                if (file.isDirectory()) {
                    this.doLookupInFileSystem(file, pkg, null, recursive);
                    continue;
                }
                if (!file.isFile() || !(name = file.getName().toLowerCase()).endsWith(".jar") && !name.endsWith(".zip")) continue;
                ZipFile zip = null;
                try {
                    zip = new ZipFile(file);
                    this.doLookupInZipFile(zip, null, recursive);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(zip);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(zip);
                continue;
            }
            if ("jar".equals(protocol)) {
                JarFile zip = null;
                try {
                    zip = ((JarURLConnection)url.openConnection()).getJarFile();
                    this.doLookupInZipFile(zip, pkg, recursive);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(zip);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(zip);
                continue;
            }
            if ("zip".equals(protocol)) {
                resource = new ZipEntryResource(url);
                try {
                    this.doLookupInZipFile(((ZipEntryResource)resource).getZipFile(), pkg, recursive);
                    continue;
                }
                finally {
                    IoUtils.closeQuietly(((ZipEntryResource)resource).getZipFile());
                    continue;
                }
            }
            if ("vfs".equals(protocol)) {
                resource = new JbossVfsResource(url);
                this.doLookupInVfsFile((JbossVfsResource)resource, pkg, null, recursive);
                continue;
            }
            throw new IllegalStateException("Unsupported url format: " + url.toString());
        }
    }

    private void doLookupInFileSystem(File dir, String pkg, String relativePathName, boolean recursive) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String javaName = file.getName();
            if (pkg != null) {
                javaName = pkg + '.' + javaName;
            }
            if (file.isFile()) {
                javaName = StringUtils.removeEnd(javaName, ".class");
            }
            String pathName = '/' + file.getName();
            if (relativePathName != null) {
                pathName = relativePathName + pathName;
            }
            ResourceEntry entry = new ResourceEntry(new FileSystemResource(file), javaName, pathName);
            if (file.isDirectory()) {
                if (!this.visitDirectory(entry) || !recursive) continue;
                this.doLookupInFileSystem(file, javaName, pathName, true);
                continue;
            }
            this.visitFile(entry);
        }
    }

    private void doLookupInZipFile(ZipFile zip, String pkg, boolean recursive) {
        ArrayList<String> skipDirs = null;
        String rootdir = pkg == null ? null : pkg.replace('.', '/') + '/';
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            String relativePathName;
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            String qualifiedJavaName = entry.isDirectory() ? entryName.substring(0, entryName.length() - 1).replace('/', '.') : (entryName.endsWith(".class") ? entryName.substring(0, entryName.length() - 6).replace('/', '.') : null);
            ResourceEntry resourceEntry = null;
            if (rootdir == null) {
                ZipEntryResource resource = new ZipEntryResource(zip, entry);
                String relativePathName2 = StringUtils.removeEnd(entryName, "/");
                resourceEntry = new ResourceEntry(resource, qualifiedJavaName, relativePathName2);
            } else if (entryName.startsWith(rootdir) && (relativePathName = entryName.substring(rootdir.length() - 1)).length() > 1) {
                relativePathName = StringUtils.removeEnd(relativePathName, "/");
                if (recursive || relativePathName.lastIndexOf(47) <= 0) {
                    ZipEntryResource resource = new ZipEntryResource(zip, entry);
                    resourceEntry = new ResourceEntry(resource, qualifiedJavaName, relativePathName);
                }
            }
            if (resourceEntry == null) continue;
            if (entry.isDirectory()) {
                if (this.visitDirectory(resourceEntry)) continue;
                if (skipDirs == null) {
                    skipDirs = new ArrayList<String>();
                }
                skipDirs.add(entryName);
                continue;
            }
            if (skipDirs != null) {
                for (String dir : skipDirs) {
                    if (!entryName.startsWith(dir)) continue;
                    resourceEntry = null;
                    break;
                }
            }
            if (resourceEntry == null) continue;
            this.visitFile(resourceEntry);
        }
    }

    private void doLookupInVfsFile(JbossVfsResource resource, String pkg, String relativePathName, boolean recursive) {
        List<JbossVfsResource> children = resource.getChildren();
        for (JbossVfsResource file : children) {
            String javaName = file.getFileName();
            if (pkg != null) {
                javaName = pkg + '.' + javaName;
            }
            if (file.isFile()) {
                javaName = StringUtils.removeEnd(javaName, ".class");
            }
            String pathName = '/' + file.getFileName();
            if (relativePathName != null) {
                pathName = relativePathName + pathName;
            }
            ResourceEntry entry = new ResourceEntry(file, javaName, pathName);
            if (file.isDirectory()) {
                if (!this.visitDirectory(entry) || !recursive) continue;
                this.doLookupInVfsFile(file, javaName, pathName, true);
                continue;
            }
            this.visitFile(entry);
        }
    }

    protected boolean visitDirectory(ResourceEntry dir) {
        return true;
    }

    protected void visitFile(ResourceEntry file) {
    }

    public static final class ResourceEntry
    extends AbstractResource {
        private final Resource resource;
        private final String qualifiedJavaName;

        public ResourceEntry(Resource resource, String qualifiedJavaName, String relativePathName) {
            this.resource = resource;
            this.qualifiedJavaName = qualifiedJavaName;
            this.relativePathName = relativePathName;
        }

        @Override
        public InputStream openStream() throws ResourceNotFoundException {
            return this.resource.openStream();
        }

        @Override
        public byte[] toByteArray() throws ResourceNotFoundException {
            return this.resource.toByteArray();
        }

        @Override
        public char[] toCharArray(Charset charset) throws ResourceNotFoundException {
            return this.resource.toCharArray(charset);
        }

        @Override
        public String toString(Charset charset) throws ResourceNotFoundException {
            return this.resource.toString(charset);
        }

        @Override
        public File getFile() {
            return this.resource.getFile();
        }

        @Override
        public URI getURI() {
            return this.resource.getURI();
        }

        @Override
        public URL getURL() {
            return this.resource.getURL();
        }

        @Override
        public boolean exist() {
            return this.resource.exist();
        }

        @Override
        public boolean isDirectory() {
            return this.resource.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.resource.isFile();
        }

        @Override
        public String getFileName() {
            return this.resource.getFileName();
        }

        @Override
        public long length() {
            return this.resource.length();
        }

        @Override
        public long lastModified() {
            return this.resource.lastModified();
        }

        public String getQualifiedJavaName() {
            return this.qualifiedJavaName;
        }

        public boolean isJavaClass() {
            return this.relativePathName.endsWith(".class");
        }

        public String toString() {
            return this.resource.toString();
        }
    }
}

