/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.finder;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import jetbrick.io.finder.AnnotationClassReader;
import jetbrick.io.finder.FileFinder;
import jetbrick.util.ClassLoaderUtils;
import jetbrick.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassFinder {
    private static final Logger log = LoggerFactory.getLogger(ClassFinder.class);

    public static Set<Class<?>> getClasses(Collection<String> packageNames, boolean recursive, Collection<Class<? extends Annotation>> annotations, final boolean skiperrors) {
        final AnnotationClassReader reader = new AnnotationClassReader();
        for (Class<? extends Annotation> annotation : annotations) {
            reader.addAnnotation(annotation);
        }
        final ClassLoader loader = ClassLoaderUtils.getDefault();
        final LinkedHashSet classes = new LinkedHashSet();
        FileFinder finder = new FileFinder(){

            @Override
            public void visitFile(FileFinder.ResourceEntry file) {
                if (file.isJavaClass() && reader.isAnnotationed(file.openStream())) {
                    this.addClass(file.getQualifiedJavaName());
                }
            }

            private void addClass(String qualifiedClassName) {
                try {
                    Class<?> klass = loader.loadClass(qualifiedClassName);
                    classes.add(klass);
                }
                catch (ClassNotFoundException klass) {
                }
                catch (Exception e) {
                    if (skiperrors) {
                        log.warn("Class load error.", (Throwable)e);
                    }
                    throw ExceptionUtils.unchecked(e);
                }
            }
        };
        finder.lookupClasspath(packageNames, recursive);
        return classes;
    }
}

