/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftValue<V>> map;
    private final ReferenceQueue<V> queue;

    public SoftHashMap() {
        this.map = new HashMap<K, SoftValue<V>>();
        this.queue = new ReferenceQueue();
    }

    public SoftHashMap(int initialCapacity) {
        this.map = new HashMap<K, SoftValue<V>>(initialCapacity);
        this.queue = new ReferenceQueue();
    }

    private void processQueue() {
        SoftValue o;
        while ((o = (SoftValue)this.queue.poll()) != null) {
            this.map.remove(o.key);
        }
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        SoftValue<V> ref = this.map.get(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public V put(K key, V softValue) {
        this.processQueue();
        SoftValue ref = this.map.put(key, new SoftValue(softValue, key, this.queue));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        SoftValue<V> ref = this.map.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.map.clear();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        LinkedHashSet<Map.Entry<K, V>> result = new LinkedHashSet<Map.Entry<K, V>>();
        for (final Map.Entry<K, SoftValue<V>> entry : this.map.entrySet()) {
            final Object value = entry.getValue().get();
            if (value == null) continue;
            result.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V v) {
                    entry.setValue(new SoftValue(v, entry.getKey(), SoftHashMap.this.queue));
                    return value;
                }
            });
        }
        return result;
    }

    private static class SoftValue<T>
    extends SoftReference<T> {
        private final Object key;

        private SoftValue(T ref, Object key, ReferenceQueue<T> queue) {
            super(ref, queue);
            this.key = key;
        }
    }
}

