/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection;

import java.util.EmptyStackException;

public final class ArrayStack<T> {
    private static final int DEFAULT_CAPACITY = 16;
    private Object[] elements;
    private int size;

    public ArrayStack() {
        this(16);
    }

    public ArrayStack(int initialCapacity) {
        this.elements = new Object[initialCapacity];
        this.size = 0;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public void clear() {
        int i = this.size;
        Object[] els = this.elements;
        while (i-- > 0) {
            els[i] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public T push(T element) {
        int i = this.size++;
        Object[] els = this.elements;
        if (i >= this.elements.length) {
            Object[] objectArray = els;
            els = this.elements = new Object[i << 1];
            System.arraycopy(objectArray, 0, this.elements, 0, i);
        }
        els[i] = element;
        return element;
    }

    public T pop() throws EmptyStackException {
        int i = --this.size;
        if (this.size >= 0) {
            Object element = this.elements[i];
            this.elements[i] = null;
            return (T)element;
        }
        this.size = 0;
        throw new EmptyStackException();
    }

    public T peek() throws EmptyStackException {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return (T)this.elements[this.size - 1];
    }

    public T peek(int offset) throws IndexOutOfBoundsException {
        int index;
        if (offset >= 0 && (index = this.size - offset - 1) >= 0) {
            return (T)this.elements[index];
        }
        throw new IndexOutOfBoundsException("offset=" + offset);
    }
}

