/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean.asm;

import java.io.File;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.asm.AsmAccessor;
import jetbrick.bean.asm.AsmBuilder;
import jetbrick.bean.asm.AsmClassLoader;
import jetbrick.io.IoUtils;
import jetbrick.util.SystemUtils;
import org.slf4j.LoggerFactory;

public final class AsmFactory {
    private static int ASM_THRESHOLD_VALUE = Integer.MAX_VALUE;
    private static boolean ASM_DEBUG_ENABLED = false;

    public static int getThreshold() {
        return ASM_THRESHOLD_VALUE;
    }

    public static void setThreshold(int value) {
        ASM_THRESHOLD_VALUE = value;
    }

    public static void setDebugEnabled(boolean enabled) {
        ASM_DEBUG_ENABLED = enabled;
    }

    public static AsmAccessor generateAccessor(Class<?> delegateKlass) {
        return AsmFactory.generateAccessor(KlassInfo.create(delegateKlass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsmAccessor generateAccessor(KlassInfo delegateKlass) {
        Class<?> generatedKlass;
        AsmClassLoader loader;
        Class delegateType = delegateKlass.getType();
        String generatedKlassName = AsmFactory.class.getPackage().getName() + ".delegate." + delegateType.getName().replace('.', '_');
        AsmClassLoader asmClassLoader = loader = AsmClassLoader.get(delegateType);
        synchronized (asmClassLoader) {
            try {
                generatedKlass = loader.loadClass(generatedKlassName);
            }
            catch (ClassNotFoundException e) {
                byte[] byteCode = AsmBuilder.create(generatedKlassName, delegateKlass);
                if (ASM_DEBUG_ENABLED) {
                    File file = new File(SystemUtils.JAVA_IO_TMPDIR, ".asm/" + generatedKlassName.replace('.', '/') + ".class");
                    file.getParentFile().mkdirs();
                    LoggerFactory.getLogger(AsmFactory.class).info("AsmFactory generated {}", (Object)file);
                    IoUtils.write(byteCode, file);
                }
                generatedKlass = loader.defineClass(generatedKlassName, byteCode, delegateType.getProtectionDomain());
            }
        }
        try {
            return (AsmAccessor)generatedKlass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error constructing access class: " + generatedKlassName, e);
        }
    }
}

