/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import jetbrick.bean.ConstructorInfo;
import jetbrick.bean.ExecutableUtils;
import jetbrick.bean.FieldInfo;
import jetbrick.bean.Filters;
import jetbrick.bean.MethodInfo;
import jetbrick.bean.PropertyInfo;
import jetbrick.bean.asm.AsmAccessor;
import jetbrick.bean.asm.AsmFactory;
import jetbrick.util.concurrent.ConcurrentInitializer;
import jetbrick.util.concurrent.LazyInitializer;

public final class KlassInfo {
    private static final ConcurrentHashMap<Class<?>, KlassInfo> pool = new ConcurrentHashMap(128);
    private final Class<?> clazz;
    private final ConcurrentInitializer<List<ConstructorInfo>> declaredConstructorsGetter = new LazyInitializer<List<ConstructorInfo>>(){

        @Override
        protected List<ConstructorInfo> initialize() {
            Constructor<?>[] constructors = KlassInfo.this.clazz.getDeclaredConstructors();
            if (constructors.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<ConstructorInfo> results = new ArrayList<ConstructorInfo>(constructors.length);
            for (int i = 0; i < constructors.length; ++i) {
                results.add(new ConstructorInfo(KlassInfo.this, constructors[i], i));
            }
            results.trimToSize();
            return Collections.unmodifiableList(results);
        }
    };
    private final ConcurrentInitializer<List<MethodInfo>> declaredMethodsGetter = new LazyInitializer<List<MethodInfo>>(){

        @Override
        protected List<MethodInfo> initialize() {
            Method[] methods = KlassInfo.this.clazz.getDeclaredMethods();
            if (methods.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<MethodInfo> results = new ArrayList<MethodInfo>(methods.length);
            for (int i = 0; i < methods.length; ++i) {
                results.add(new MethodInfo(KlassInfo.this, methods[i], i));
            }
            results.trimToSize();
            return Collections.unmodifiableList(results);
        }
    };
    private final ConcurrentInitializer<List<MethodInfo>> methodsGetter = new LazyInitializer<List<MethodInfo>>(){

        @Override
        protected List<MethodInfo> initialize() {
            KlassInfo klass = KlassInfo.this;
            List<MethodInfo> declaredMethods = klass.getDeclaredMethods();
            ArrayList<MethodInfo> results = new ArrayList<MethodInfo>(declaredMethods.size() + 16);
            for (KlassInfo parent : klass.getInterfaces()) {
                for (MethodInfo method : parent.getMethods()) {
                    results.add(method);
                }
            }
            KlassInfo parent = klass.getSuperKlass();
            if (parent != null) {
                for (MethodInfo method : parent.getMethods()) {
                    if (!method.isPublic() || method.isStatic()) continue;
                    results.add(method);
                }
            }
            results.addAll(declaredMethods);
            results.trimToSize();
            return Collections.unmodifiableList(results);
        }
    };
    private final ConcurrentInitializer<List<FieldInfo>> declaredFieldsGetter = new LazyInitializer<List<FieldInfo>>(){

        @Override
        protected List<FieldInfo> initialize() {
            Field[] fields = KlassInfo.this.clazz.getDeclaredFields();
            if (fields.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<FieldInfo> results = new ArrayList<FieldInfo>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                results.add(new FieldInfo(KlassInfo.this, fields[i], i));
            }
            results.trimToSize();
            return Collections.unmodifiableList(results);
        }
    };
    private final ConcurrentInitializer<List<FieldInfo>> fieldsGetter = new LazyInitializer<List<FieldInfo>>(){

        @Override
        protected List<FieldInfo> initialize() {
            KlassInfo klass = KlassInfo.this;
            List<FieldInfo> declaredFields = klass.getDeclaredFields();
            ArrayList<FieldInfo> results = new ArrayList<FieldInfo>(declaredFields.size() + 8);
            results.addAll(declaredFields);
            for (KlassInfo parent : klass.getInterfaces()) {
                for (FieldInfo field : parent.getFields()) {
                    if (!field.isPublic() || field.isStatic()) continue;
                    results.add(field);
                }
            }
            KlassInfo parent = klass.getSuperKlass();
            if (parent != null) {
                for (FieldInfo field : parent.getFields()) {
                    if (!field.isPublic() || field.isStatic()) continue;
                    results.add(field);
                }
            }
            results.trimToSize();
            return Collections.unmodifiableList(results);
        }
    };
    private final ConcurrentInitializer<List<PropertyInfo>> propertiesGetter = new LazyInitializer<List<PropertyInfo>>(){

        @Override
        protected List<PropertyInfo> initialize() {
            List methods = (List)KlassInfo.this.methodsGetter.get();
            HashMap<String, PropertyInfo> map = new HashMap<String, PropertyInfo>(methods.size());
            for (MethodInfo method : methods) {
                PropertyInfo propertyInfo;
                String name;
                if (method.isStatic() || !method.isPublic()) continue;
                if (method.isReadMethod()) {
                    name = method.getPropertyName();
                    propertyInfo = (PropertyInfo)map.get(name);
                    if (propertyInfo == null) {
                        propertyInfo = new PropertyInfo(KlassInfo.this, name);
                        map.put(name, propertyInfo);
                    }
                    propertyInfo.setGetter(method);
                    continue;
                }
                if (!method.isWriteMethod()) continue;
                name = method.getPropertyName();
                propertyInfo = (PropertyInfo)map.get(name);
                if (propertyInfo == null) {
                    propertyInfo = new PropertyInfo(KlassInfo.this, name);
                    map.put(name, propertyInfo);
                }
                propertyInfo.setSetter(method);
            }
            if (map.size() == 0) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList(map.values()));
        }
    };
    private AsmAccessor asmAccessor;
    private int asmCallNumber = 0;

    public static KlassInfo create(Class<?> clazz) {
        KlassInfo old;
        KlassInfo klass = pool.get(clazz);
        if (klass == null && (old = pool.putIfAbsent(clazz, klass = new KlassInfo(clazz))) != null) {
            klass = old;
        }
        return klass;
    }

    private KlassInfo(Class<?> type) {
        this.clazz = type;
    }

    public <T> Class<T> getType() {
        return this.clazz;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    public KlassInfo getSuperKlass() {
        Class<?> superKlass = this.clazz.getSuperclass();
        return superKlass == null ? null : KlassInfo.create(superKlass);
    }

    public List<KlassInfo> getInterfaces() {
        Class<?>[] interfaces = this.clazz.getInterfaces();
        if (interfaces.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<KlassInfo> results = new ArrayList<KlassInfo>(interfaces.length);
        for (Class<?> intf : interfaces) {
            results.add(KlassInfo.create(intf));
        }
        return results;
    }

    public Annotation[] getAnnotations() {
        return this.clazz.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.clazz.getAnnotation(annotationClass);
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationClass) {
        return this.clazz.isAnnotationPresent(annotationClass);
    }

    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public List<ConstructorInfo> getDeclaredConstructors() {
        return this.declaredConstructorsGetter.get();
    }

    public ConstructorInfo getDeclaredConstructor(Class<?> ... parameterTypes) {
        return ExecutableUtils.getExecutable(this.declaredConstructorsGetter.get(), null, parameterTypes);
    }

    public ConstructorInfo searchDeclaredConstructor(Class<?> ... parameterTypes) {
        ConstructorInfo constructor = ExecutableUtils.getExecutable(this.declaredConstructorsGetter.get(), null, parameterTypes);
        if (constructor == null) {
            constructor = ExecutableUtils.searchExecutable(this.declaredConstructorsGetter.get(), null, parameterTypes);
        }
        return constructor;
    }

    public ConstructorInfo getDeclaredConstructor(Constructor<?> constructor) {
        for (ConstructorInfo info : this.declaredConstructorsGetter.get()) {
            if (info.getConstructor() != constructor) continue;
            return info;
        }
        return null;
    }

    public ConstructorInfo getDefaultConstructor() {
        for (ConstructorInfo info : this.declaredConstructorsGetter.get()) {
            if (!info.isDefault()) continue;
            return info;
        }
        return null;
    }

    public List<MethodInfo> getDeclaredMethods() {
        return this.declaredMethodsGetter.get();
    }

    public List<MethodInfo> getDeclaredMethods(Filters.MethodFilter filter) {
        List<MethodInfo> methods = this.declaredMethodsGetter.get();
        if (methods.size() == 0) {
            return methods;
        }
        ArrayList<MethodInfo> results = new ArrayList<MethodInfo>(methods.size());
        for (MethodInfo method : methods) {
            if (!filter.accept(method)) continue;
            results.add(method);
        }
        return results;
    }

    public MethodInfo getDeclaredMethod(String name, Class<?> ... parameterTypes) {
        return ExecutableUtils.getExecutable(this.declaredMethodsGetter.get(), name, parameterTypes);
    }

    public MethodInfo getDeclaredMethod(Method method) {
        for (MethodInfo info : this.declaredMethodsGetter.get()) {
            if (info.getMethod() != method) continue;
            return info;
        }
        return null;
    }

    public List<MethodInfo> getMethods() {
        return this.methodsGetter.get();
    }

    public List<MethodInfo> getMethods(Filters.MethodFilter filter) {
        List<MethodInfo> methods = this.methodsGetter.get();
        if (methods.size() == 0) {
            return methods;
        }
        ArrayList<MethodInfo> results = new ArrayList<MethodInfo>(methods.size());
        for (MethodInfo method : methods) {
            if (!filter.accept(method)) continue;
            results.add(method);
        }
        return results;
    }

    public MethodInfo getMethod(String name, Class<?> ... parameterTypes) {
        return ExecutableUtils.getExecutable(this.methodsGetter.get(), name, parameterTypes);
    }

    public MethodInfo searchMethod(String name, Class<?> ... parameterTypes) {
        MethodInfo method = ExecutableUtils.getExecutable(this.methodsGetter.get(), name, parameterTypes);
        if (method == null) {
            method = ExecutableUtils.searchExecutable(this.methodsGetter.get(), name, parameterTypes);
        }
        return method;
    }

    public List<FieldInfo> getDeclaredFields() {
        return this.declaredFieldsGetter.get();
    }

    public List<FieldInfo> getDeclaredFields(Filters.FieldFilter filter) {
        List<FieldInfo> fields = this.declaredFieldsGetter.get();
        if (fields.size() == 0) {
            return fields;
        }
        ArrayList<FieldInfo> results = new ArrayList<FieldInfo>(fields.size());
        for (FieldInfo field : fields) {
            if (!filter.accept(field)) continue;
            results.add(field);
        }
        return results;
    }

    public FieldInfo getDeclaredField(String name) {
        for (FieldInfo field : this.declaredFieldsGetter.get()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public FieldInfo getDeclaredField(Field field) {
        for (FieldInfo info : this.declaredFieldsGetter.get()) {
            if (info.getField() != field) continue;
            return info;
        }
        return null;
    }

    public List<FieldInfo> getFields() {
        return this.fieldsGetter.get();
    }

    public List<FieldInfo> getFields(Filters.FieldFilter filter) {
        List<FieldInfo> fields = this.fieldsGetter.get();
        if (fields.size() == 0) {
            return fields;
        }
        ArrayList<FieldInfo> results = new ArrayList<FieldInfo>(fields.size());
        for (FieldInfo field : fields) {
            if (!filter.accept(field)) continue;
            results.add(field);
        }
        return results;
    }

    public FieldInfo getField(String name) {
        for (FieldInfo field : this.fieldsGetter.get()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public List<PropertyInfo> getProperties() {
        return this.propertiesGetter.get();
    }

    public PropertyInfo getProperty(String name) {
        for (PropertyInfo prop : this.propertiesGetter.get()) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    protected AsmAccessor getAsmAccessor() {
        if (this.asmAccessor == null) {
            if (this.asmCallNumber >= AsmFactory.getThreshold()) {
                this.asmAccessor = AsmFactory.generateAccessor(this);
            } else {
                ++this.asmCallNumber;
            }
        }
        return this.asmAccessor;
    }

    public Object newInstance() throws IllegalStateException {
        AsmAccessor accessor = this.getAsmAccessor();
        if (accessor == null) {
            ConstructorInfo ctor = this.getDefaultConstructor();
            if (ctor != null) {
                return ctor.newInstance(new Object[0]);
            }
            throw new IllegalStateException("No default constructor");
        }
        return accessor.newInstance();
    }

    public String toString() {
        return this.clazz.toString();
    }
}

