/*
 * Decompiled with CFR 0.152.
 */
package com.github.streamone.shiro.session;

import com.github.streamone.shiro.session.RedissonSessionManager;
import java.io.Serializable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DelegatingSession;
import org.apache.shiro.session.mgt.NativeSessionManager;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.WebSessionKey;
import org.apache.shiro.web.session.mgt.WebSessionManager;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonWebSessionManager
extends RedissonSessionManager
implements WebSessionManager {
    public static final Logger logger = LoggerFactory.getLogger(RedissonWebSessionManager.class);
    private Cookie sessionIdCookie;
    private boolean sessionIdCookieEnabled;
    private boolean sessionIdUrlRewritingEnabled;

    public RedissonWebSessionManager() {
        SimpleCookie cookie = new SimpleCookie("JSESSIONID");
        cookie.setHttpOnly(true);
        this.sessionIdCookie = cookie;
        this.sessionIdCookieEnabled = true;
        this.sessionIdUrlRewritingEnabled = true;
    }

    private void storeSessionId(Serializable currentId, HttpServletRequest request, HttpServletResponse response) {
        if (currentId == null) {
            String msg = "sessionId cannot be null when persisting for subsequent requests.";
            throw new IllegalArgumentException(msg);
        }
        Cookie template = this.getSessionIdCookie();
        SimpleCookie cookie = new SimpleCookie(template);
        String idString = currentId.toString();
        cookie.setValue(idString);
        cookie.saveTo(request, response);
        if (logger.isTraceEnabled()) {
            logger.trace("Set session ID cookie for session with id {}", (Object)idString);
        }
    }

    private void removeSessionIdCookie(HttpServletRequest request, HttpServletResponse response) {
        this.getSessionIdCookie().removeFrom(request, response);
    }

    private String getSessionIdCookieValue(ServletRequest request, ServletResponse response) {
        if (!this.isSessionIdCookieEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Session ID cookie is disabled - session id will not be acquired from a request cookie.");
            }
            return null;
        }
        if (!(request instanceof HttpServletRequest)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Current request is not an HttpServletRequest - cannot get session ID cookie.  Returning null.");
            }
            return null;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        return this.getSessionIdCookie().readValue(httpRequest, WebUtils.toHttp((ServletResponse)response));
    }

    private Serializable getReferencedSessionId(ServletRequest request, ServletResponse response) {
        String id = this.getSessionIdCookieValue(request, response);
        if (id != null) {
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)"cookie");
        } else {
            String name;
            id = this.getUriPathSegmentParamValue(request, "JSESSIONID");
            if (id == null && (id = request.getParameter(name = this.getSessionIdName())) == null) {
                id = request.getParameter(name.toLowerCase());
            }
            if (id != null) {
                request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)"url");
            }
        }
        if (id != null) {
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID, (Object)id);
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_IS_VALID, (Object)Boolean.TRUE);
        }
        request.setAttribute(ShiroHttpServletRequest.SESSION_ID_URL_REWRITING_ENABLED, (Object)this.isSessionIdUrlRewritingEnabled());
        return id;
    }

    private String getUriPathSegmentParamValue(ServletRequest servletRequest, String paramName) {
        int index;
        if (!(servletRequest instanceof HttpServletRequest)) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String uri = request.getRequestURI();
        if (uri == null) {
            return null;
        }
        int queryStartIndex = uri.indexOf(63);
        if (queryStartIndex >= 0) {
            uri = uri.substring(0, queryStartIndex);
        }
        if ((index = uri.indexOf(59)) < 0) {
            return null;
        }
        String token = paramName + "=";
        if ((index = (uri = uri.substring(index + 1)).lastIndexOf(token)) < 0) {
            return null;
        }
        if ((index = (uri = uri.substring(index + token.length())).indexOf(59)) >= 0) {
            uri = uri.substring(0, index);
        }
        return uri;
    }

    private String getSessionIdName() {
        String name;
        String string = name = this.sessionIdCookie != null ? this.sessionIdCookie.getName() : null;
        if (name == null) {
            name = "JSESSIONID";
        }
        return name;
    }

    protected Session createExposedSession(Session session, SessionContext context) {
        if (!WebUtils.isWeb((Object)context)) {
            return super.createExposedSession(session, context);
        }
        return this.doCreateExposedSession(session, context);
    }

    protected Session createExposedSession(Session session, SessionKey key) {
        if (!WebUtils.isWeb((Object)key)) {
            return super.createExposedSession(session, key);
        }
        return this.doCreateExposedSession(session, key);
    }

    private Session doCreateExposedSession(Session session, Object source) {
        ServletRequest request = WebUtils.getRequest((Object)source);
        ServletResponse response = WebUtils.getResponse((Object)source);
        WebSessionKey key = new WebSessionKey(session.getId(), request, response);
        return new DelegatingSession((NativeSessionManager)this, (SessionKey)key);
    }

    protected void onStart(Session session, SessionContext context) {
        super.onStart(session, context);
        if (!WebUtils.isHttp((Object)context)) {
            if (logger.isDebugEnabled()) {
                logger.debug("SessionContext argument is not HTTP compatible or does not have an HTTP request/response pair. No session ID cookie will be set.");
            }
            return;
        }
        HttpServletRequest request = WebUtils.getHttpRequest((Object)context);
        HttpServletResponse response = WebUtils.getHttpResponse((Object)context);
        if (this.isSessionIdCookieEnabled()) {
            Serializable sessionId = session.getId();
            this.storeSessionId(sessionId, request, response);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Session ID cookie is disabled.  No cookie has been set for new session with id {}", (Object)session.getId());
        }
        request.removeAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE);
        request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_IS_NEW, (Object)Boolean.TRUE);
    }

    @Override
    public Serializable getSessionId(SessionKey key) {
        Serializable id = super.getSessionId(key);
        if (id == null && WebUtils.isWeb((Object)key)) {
            ServletRequest request = WebUtils.getRequest((Object)key);
            ServletResponse response = WebUtils.getResponse((Object)key);
            id = this.getSessionId(request, response);
        }
        return id;
    }

    protected Serializable getSessionId(ServletRequest request, ServletResponse response) {
        return this.getReferencedSessionId(request, response);
    }

    protected void onStop(Session session, SessionKey key) {
        super.onStop(session, key);
        if (WebUtils.isHttp((Object)key)) {
            HttpServletRequest request = WebUtils.getHttpRequest((Object)key);
            HttpServletResponse response = WebUtils.getHttpResponse((Object)key);
            if (logger.isDebugEnabled()) {
                logger.debug("Session has been stopped (subject logout or explicit stop).  Removing session ID cookie.");
            }
            this.removeSessionIdCookie(request, response);
        } else if (logger.isDebugEnabled()) {
            logger.debug("SessionKey argument is not HTTP compatible or does not have an HTTP request/response pair. Session ID cookie will not be removed due to stopped session.");
        }
    }

    public boolean isServletContainerSessions() {
        return false;
    }

    public Cookie getSessionIdCookie() {
        return this.sessionIdCookie;
    }

    public void setSessionIdCookie(Cookie sessionIdCookie) {
        this.sessionIdCookie = sessionIdCookie;
    }

    public boolean isSessionIdCookieEnabled() {
        return this.sessionIdCookieEnabled;
    }

    public void setSessionIdCookieEnabled(boolean sessionIdCookieEnabled) {
        this.sessionIdCookieEnabled = sessionIdCookieEnabled;
    }

    public boolean isSessionIdUrlRewritingEnabled() {
        return this.sessionIdUrlRewritingEnabled;
    }

    public void setSessionIdUrlRewritingEnabled(boolean sessionIdUrlRewritingEnabled) {
        this.sessionIdUrlRewritingEnabled = sessionIdUrlRewritingEnabled;
    }
}

