/*
 * Decompiled with CFR 0.152.
 */
package com.github.streamone.shiro.session;

public abstract class RedissonSessionScript {
    public static final String RETURN_CODE_EXPIRED = "-1";
    public static final String RETURN_CODE_STOPPED = "-2";
    public static final String RETURN_CODE_INVALID = "-3";
    public static final String TOUCH_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nlocal timeoutEncoded = redis.call('HGET', KEYS[1], '\"" + "timeout" + "\"')\nif timeoutEncoded == nil then\n  return " + RedissonSessionScript.makeError("-3") + "\nend\n\nlocal timeout = cjson.decode(timeoutEncoded)[2]\n\nredis.call('HSET', KEYS[1], '\"" + "lastAccessTime" + "\"', ARGV[1])\nredis.call('PEXPIRE', KEYS[1], timeout)\nredis.call('PEXPIRE', KEYS[2], timeout)";
    public static final String INIT_SCRIPT = "redis.call('HMSET', KEYS[1], '\"id\"', ARGV[1], '\"timeout\"', ARGV[2],\n  '\"startTimestamp\"', ARGV[3], '\"lastAccessTime\"', ARGV[3],\n  '\"host\"', ARGV[4])\nlocal timeout = cjson.decode(ARGV[2])[2]\nredis.call('PEXPIRE', KEYS[1], timeout)";
    public static final String GET_START_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nlocal startTime = redis.call('HGET', KEYS[1], '\"" + "startTimestamp" + "\"')\nif startTime == nil then\n  return " + RedissonSessionScript.makeError("-3") + "\nend\n\nreturn startTime";
    public static final String GET_LAST_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nlocal lastTime = redis.call('HGET', KEYS[1], '\"" + "lastAccessTime" + "\"')\nif lastTime == nil then\n  return " + RedissonSessionScript.makeError("-3") + "\nend\n\nreturn lastTime";
    public static final String GET_TIMEOUT_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nlocal timeout = redis.call('HGET', KEYS[1], '\"" + "timeout" + "\"')\nif timeout == nil then\n  return " + RedissonSessionScript.makeError("-3") + "\nend\n\nreturn timeout";
    public static final String GET_HOST_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nlocal host = redis.call('HGET', KEYS[1], '\"" + "host" + "\"')\nif host == nil then\n  return " + RedissonSessionScript.makeError("-3") + "\nend\n\nreturn host";
    public static final String SET_TIMEOUT_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nlocal timeout = redis.call('HGET', KEYS[1], '\"" + "timeout" + "\"')\nif timeout == nil then\n  return " + RedissonSessionScript.makeError("-3") + "\nend\n\nredis.call('HSET', KEYS[1], '\"" + "timeout" + "\"', ARGV[1])\nlocal newTimeout = cjson.decode(ARGV[1])[2]\nredis.call('PEXPIRE', KEYS[1], newTimeout)\nredis.call('PEXPIRE', KEYS[2], newTimeout)";
    public static final String STOP_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nredis.call('HSET', KEYS[1], '\"" + "stopTimestamp" + "\"', ARGV[1])";
    public static final String GET_ATTRKEYS_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nreturn redis.call('HKEYS', KEYS[2])";
    public static final String GET_ATTR_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nreturn redis.call('HGET', KEYS[2], ARGV[1])";
    public static final String REMOVE_ATTR_SCRIPT = "if redis.call('PTTL', KEYS[1]) <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nlocal attr = redis.call('HGET', KEYS[2], ARGV[1])\nif attr ~= nil then\n  redis.call('HDEL', KEYS[2], ARGV[1])\nend\n\nreturn attr";
    public static final String SET_ATTR_SCRIPT = "local pttl = redis.call('PTTL', KEYS[1])\nif pttl <= 0 then\n  return " + RedissonSessionScript.makeError("-1") + "\nend\n\nif redis.call('HEXISTS', KEYS[1], '\"" + "stopTimestamp" + "\"') == 1 then\n  return " + RedissonSessionScript.makeError("-2") + "\nend\n\nredis.call('HSET', KEYS[2], ARGV[1], ARGV[2])\n-- redis auto delete key of hash when it is empty.\n-- then, expire time of the hash will be lost.\nif redis.call('PTTL', KEYS[2]) <= 0 then\n  redis.call('PEXPIRE', KEYS[2], pttl)\nend";
    public static final String DELETE_SCRIPT = "redis.call('UNLINK', KEYS[1], KEYS[2])";
    public static final String READ_SCRIPT = "return redis.call('PTTL', KEYS[1])";

    private static String makeError(String errMsg) {
        return "redis.error_reply(\"" + errMsg + "\")";
    }
}

