/*
 * Decompiled with CFR 0.152.
 */
package com.github.streamone.shiro.session;

import java.io.Serializable;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.AbstractNativeSessionManager;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionFactory;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SimpleSessionFactory;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonSessionManager
extends AbstractNativeSessionManager {
    private static final Logger logger = LoggerFactory.getLogger(RedissonSessionManager.class);
    private SessionFactory sessionFactory = new SimpleSessionFactory();
    protected SessionDAO sessionDAO;

    protected Session createSession(SessionContext context) throws AuthorizationException {
        Session s = this.newSessionInstance(context);
        if (logger.isTraceEnabled()) {
            logger.trace("Creating session for host {}", (Object)s.getHost());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new EIS record for new session instance [" + s + "]");
        }
        this.sessionDAO.create(s);
        return s;
    }

    protected Session doGetSession(SessionKey key) throws InvalidSessionException {
        Serializable sessionId;
        if (logger.isTraceEnabled()) {
            logger.trace("Attempting to retrieve session with key {}", (Object)key);
        }
        if ((sessionId = this.getSessionId(key)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to resolve session ID from SessionKey [{}].  Returning null to indicate a session could not be found.", (Object)key);
            }
            return null;
        }
        Session s = this.sessionDAO.readSession(sessionId);
        if (s == null) {
            String msg = "Could not find session with ID [" + sessionId + "]";
            throw new UnknownSessionException(msg);
        }
        return s;
    }

    protected void afterStopped(Session session) {
        this.sessionDAO.delete(session);
    }

    protected Session newSessionInstance(SessionContext context) {
        return this.getSessionFactory().createSession(context);
    }

    protected Serializable getSessionId(SessionKey sessionKey) {
        return sessionKey.getSessionId();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionDAO getSessionDAO() {
        return this.sessionDAO;
    }

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
    }
}

