/*
 * Decompiled with CFR 0.152.
 */
package com.github.streamone.shiro.session;

import com.github.streamone.shiro.session.RedissonSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.redisson.RedissonScript;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;

public class RedissonSessionDao
extends AbstractSessionDAO {
    public static final String SESSION_INFO_KEY_PREFIX = "session:info:";
    public static final String SESSION_ATTR_KEY_PREFIX = "session:attr:";
    private RedissonClient redisson;
    private Codec codec = new JsonJacksonCodec();

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        String infoKey = this.getSessionInfoKey(sessionId.toString());
        String attrKey = this.getSessionAttrKey(sessionId.toString());
        new RedissonSession(this.redisson, this.codec, infoKey, attrKey, session);
        return sessionId;
    }

    protected Session doReadSession(Serializable sessionId) {
        String infoKey = this.getSessionInfoKey(sessionId.toString());
        String attrKey = this.getSessionAttrKey(sessionId.toString());
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(infoKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.codec);
        Long remainTimeToLive = (Long)script.eval(infoKey, RScript.Mode.READ_ONLY, "return redis.call('PTTL', KEYS[1])", RScript.ReturnType.INTEGER, keys, new Object[0]);
        if (remainTimeToLive > 0L) {
            return new RedissonSession(this.redisson, this.codec, infoKey, attrKey, sessionId);
        }
        return null;
    }

    public void update(Session session) throws UnknownSessionException {
    }

    public void delete(Session session) {
        if (session == null || session.getId() == null || "".equals(session.getId())) {
            return;
        }
        Serializable sessionId = session.getId();
        String infoKey = this.getSessionInfoKey(sessionId.toString());
        String attrKey = this.getSessionAttrKey(sessionId.toString());
        ArrayList<String> keys = new ArrayList<String>(2);
        keys.add(infoKey);
        keys.add(attrKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.codec);
        script.eval(infoKey, RScript.Mode.READ_WRITE, "redis.call('UNLINK', KEYS[1], KEYS[2])", RScript.ReturnType.VALUE, keys, new Object[0]);
    }

    public Collection<Session> getActiveSessions() {
        return Collections.EMPTY_LIST;
    }

    protected String getSessionInfoKey(String sessionId) {
        StringBuilder name = new StringBuilder(SESSION_INFO_KEY_PREFIX);
        name.append("{").append(sessionId).append("}");
        return name.toString();
    }

    protected String getSessionAttrKey(String sessionId) {
        StringBuilder name = new StringBuilder(SESSION_ATTR_KEY_PREFIX);
        name.append("{").append(sessionId).append("}");
        return name.toString();
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public void setRedisson(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }
}

