/*
 * Decompiled with CFR 0.152.
 */
package com.github.streamone.shiro.session;

import com.github.streamone.shiro.session.RedissonSessionScript;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.StoppedSessionException;
import org.redisson.RedissonScript;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;

public class RedissonSession
implements Session {
    public static final String INFO_ID_KEY = "id";
    public static final String INFO_START_KEY = "startTimestamp";
    public static final String INFO_STOP_KEY = "stopTimestamp";
    public static final String INFO_LAST_KEY = "lastAccessTime";
    public static final String INFO_TIMEOUT_KEY = "timeout";
    public static final String INFO_HOST_KEY = "host";
    private RedissonClient redisson;
    private Codec infoCodec;
    private Codec codec;
    private String infoKey;
    private String attrKey;
    private Serializable id;

    public RedissonSession(RedissonClient redisson, Codec codec, String infoKey, String attrKey, Serializable id) {
        this.codec = this.infoCodec = new JsonJacksonCodec();
        if (redisson == null || infoKey == null || attrKey == null || id == null) {
            throw new IllegalArgumentException("Arguments must not be null!");
        }
        this.redisson = redisson;
        if (codec != null) {
            this.codec = codec;
        }
        this.infoKey = infoKey;
        this.attrKey = attrKey;
        this.id = id;
    }

    public RedissonSession(RedissonClient redisson, Codec codec, String infoKey, String attrKey, Session session) {
        this.codec = this.infoCodec = new JsonJacksonCodec();
        if (redisson == null || infoKey == null || attrKey == null || session == null) {
            throw new IllegalArgumentException("Arguments must not be null!");
        }
        if (session.getId() == null) {
            throw new IllegalArgumentException("Session id must not be null!");
        }
        this.redisson = redisson;
        if (codec != null) {
            this.codec = codec;
        }
        this.infoKey = infoKey;
        this.attrKey = attrKey;
        this.id = session.getId();
        this.init(session);
    }

    protected void init(Session session) {
        long timeout = session.getTimeout() > 0L ? session.getTimeout() : 1800000L;
        Date startTimeStamp = session.getStartTimestamp();
        startTimeStamp = startTimeStamp != null ? startTimeStamp : new Date();
        String host = session.getHost();
        host = host != null ? host : "";
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(this.infoKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.infoCodec);
        script.eval(this.infoKey, RScript.Mode.READ_WRITE, "redis.call('HMSET', KEYS[1], '\"id\"', ARGV[1], '\"timeout\"', ARGV[2],\n  '\"startTimestamp\"', ARGV[3], '\"lastAccessTime\"', ARGV[3],\n  '\"host\"', ARGV[4])\nlocal timeout = cjson.decode(ARGV[2])[2]\nredis.call('PEXPIRE', KEYS[1], timeout)", RScript.ReturnType.VALUE, keys, new Object[]{session.getId(), timeout, startTimeStamp, host});
    }

    public Serializable getId() {
        return this.id;
    }

    public Date getStartTimestamp() {
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(this.infoKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.infoCodec);
        Date res = null;
        try {
            res = (Date)script.eval(this.infoKey, RScript.Mode.READ_ONLY, RedissonSessionScript.GET_START_SCRIPT, RScript.ReturnType.MAPVALUE, keys, new Object[0]);
        }
        catch (RedisException e) {
            this.convertException(e);
        }
        if (res == null) {
            throw new InvalidSessionException();
        }
        return res;
    }

    public Date getLastAccessTime() {
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(this.infoKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.infoCodec);
        Date res = null;
        try {
            res = (Date)script.eval(this.infoKey, RScript.Mode.READ_ONLY, RedissonSessionScript.GET_LAST_SCRIPT, RScript.ReturnType.MAPVALUE, keys, new Object[0]);
        }
        catch (RedisException e) {
            this.convertException(e);
        }
        if (res == null) {
            throw new InvalidSessionException();
        }
        return res;
    }

    public long getTimeout() throws InvalidSessionException {
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(this.infoKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.infoCodec);
        Long res = null;
        try {
            res = (Long)script.eval(this.infoKey, RScript.Mode.READ_ONLY, RedissonSessionScript.GET_TIMEOUT_SCRIPT, RScript.ReturnType.MAPVALUE, keys, new Object[0]);
        }
        catch (RedisException e) {
            this.convertException(e);
        }
        if (res == null) {
            throw new InvalidSessionException();
        }
        return res;
    }

    public void setTimeout(long maxIdleTimeInMillis) throws InvalidSessionException {
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(this.infoKey);
        keys.add(this.attrKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.infoCodec);
        try {
            script.eval(this.infoKey, RScript.Mode.READ_WRITE, RedissonSessionScript.SET_TIMEOUT_SCRIPT, RScript.ReturnType.VALUE, keys, new Object[]{maxIdleTimeInMillis});
        }
        catch (RedisException e) {
            this.convertException(e);
        }
    }

    public String getHost() {
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(this.infoKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.infoCodec);
        String res = null;
        try {
            res = (String)script.eval(this.infoKey, RScript.Mode.READ_ONLY, RedissonSessionScript.GET_HOST_SCRIPT, RScript.ReturnType.MAPVALUE, keys, new Object[0]);
        }
        catch (RedisException e) {
            this.convertException(e);
        }
        if (res == null) {
            throw new InvalidSessionException();
        }
        return res;
    }

    public void touch() throws InvalidSessionException {
        ArrayList<String> keys = new ArrayList<String>(2);
        keys.add(this.infoKey);
        keys.add(this.attrKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.infoCodec);
        try {
            script.eval(this.infoKey, RScript.Mode.READ_WRITE, RedissonSessionScript.TOUCH_SCRIPT, RScript.ReturnType.VALUE, keys, new Object[]{new Date()});
        }
        catch (RedisException e) {
            this.convertException(e);
        }
    }

    public void stop() throws InvalidSessionException {
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(this.infoKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.infoCodec);
        try {
            script.eval(this.infoKey, RScript.Mode.READ_WRITE, RedissonSessionScript.STOP_SCRIPT, RScript.ReturnType.VALUE, keys, new Object[]{new Date()});
        }
        catch (RedisException e) {
            this.convertException(e);
        }
    }

    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        ArrayList<String> keys = new ArrayList<String>(2);
        keys.add(this.infoKey);
        keys.add(this.attrKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.codec);
        Collection res = null;
        try {
            res = (Collection)script.eval(this.infoKey, RScript.Mode.READ_ONLY, RedissonSessionScript.GET_ATTRKEYS_SCRIPT, RScript.ReturnType.MAPVALUELIST, keys, new Object[0]);
        }
        catch (RedisException e) {
            this.convertException(e);
        }
        if (res == null) {
            throw new InvalidSessionException();
        }
        return res;
    }

    public Object getAttribute(Object key) throws InvalidSessionException {
        ArrayList<String> keys = new ArrayList<String>(2);
        keys.add(this.infoKey);
        keys.add(this.attrKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.codec);
        Object res = null;
        try {
            res = script.eval(this.infoKey, RScript.Mode.READ_ONLY, RedissonSessionScript.GET_ATTR_SCRIPT, RScript.ReturnType.MAPVALUE, keys, new Object[]{key});
        }
        catch (RedisException e) {
            this.convertException(e);
        }
        return res;
    }

    public void setAttribute(Object key, Object value) throws InvalidSessionException {
        ArrayList<String> keys = new ArrayList<String>(2);
        keys.add(this.infoKey);
        keys.add(this.attrKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.codec);
        try {
            script.eval(this.infoKey, RScript.Mode.READ_WRITE, RedissonSessionScript.SET_ATTR_SCRIPT, RScript.ReturnType.VALUE, keys, new Object[]{key, value});
        }
        catch (RedisException e) {
            this.convertException(e);
        }
    }

    public Object removeAttribute(Object key) throws InvalidSessionException {
        ArrayList<String> keys = new ArrayList<String>(2);
        keys.add(this.infoKey);
        keys.add(this.attrKey);
        RedissonScript script = (RedissonScript)this.redisson.getScript(this.codec);
        Object res = null;
        try {
            res = script.eval(this.infoKey, RScript.Mode.READ_WRITE, RedissonSessionScript.REMOVE_ATTR_SCRIPT, RScript.ReturnType.MAPVALUE, keys, new Object[]{key});
        }
        catch (RedisException e) {
            this.convertException(e);
        }
        return res;
    }

    private void convertException(RedisException e) {
        String errMsg = e.getMessage();
        if ("-1".equals(errMsg)) {
            throw new ExpiredSessionException();
        }
        if ("-2".equals(errMsg)) {
            throw new StoppedSessionException();
        }
        if ("-3".equals(errMsg)) {
            throw new InvalidSessionException();
        }
        throw e;
    }
}

