/*
 * Decompiled with CFR 0.152.
 */
package com.github.streamone.shiro.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.NullValue;

public class RedissonShiroCache<K, V>
implements Cache<K, V> {
    private RMapCache<K, Object> mapCache;
    private final RMap<K, Object> map;
    private CacheConfig config;
    private final boolean allowNullValues;
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();

    public RedissonShiroCache(RMapCache<K, Object> mapCache, CacheConfig config, boolean allowNullValues) {
        this.mapCache = mapCache;
        this.map = mapCache;
        this.config = config;
        this.allowNullValues = allowNullValues;
    }

    public RedissonShiroCache(RMap<K, Object> map, boolean allowNullValues) {
        this.map = map;
        this.allowNullValues = allowNullValues;
    }

    public V get(K key) throws CacheException {
        Object value = this.map.get(key);
        if (value == null) {
            this.addCacheMiss();
        } else {
            this.addCacheHit();
        }
        return this.fromStoreValue(value);
    }

    public V put(K key, V value) throws CacheException {
        if (!this.allowNullValues && value == null) {
            Object previous = this.mapCache != null ? this.mapCache.remove(key) : this.map.remove(key);
            return this.fromStoreValue(previous);
        }
        Object val = this.toStoreValue(value);
        Object previous = this.mapCache != null ? this.mapCache.put(key, val, this.config.getTTL(), TimeUnit.MILLISECONDS, this.config.getMaxIdleTime(), TimeUnit.MILLISECONDS) : this.map.put(key, val);
        return this.fromStoreValue(previous);
    }

    public void fastPut(K key, V value) throws CacheException {
        if (!this.allowNullValues && value == null) {
            if (this.mapCache != null) {
                this.mapCache.fastRemove(new Object[]{key});
            } else {
                this.map.fastRemove(new Object[]{key});
            }
            return;
        }
        Object val = this.toStoreValue(value);
        if (this.mapCache != null) {
            this.mapCache.fastPut(key, val, this.config.getTTL(), TimeUnit.MILLISECONDS, this.config.getMaxIdleTime(), TimeUnit.MILLISECONDS);
        } else {
            this.map.fastPut(key, val);
        }
    }

    public V putIfAbsent(K key, V value) throws CacheException {
        if (!this.allowNullValues && value == null) {
            Object previous = this.mapCache != null ? this.mapCache.get(key) : this.map.get(key);
            return this.fromStoreValue(previous);
        }
        Object val = this.toStoreValue(value);
        Object previous = this.mapCache != null ? this.mapCache.putIfAbsent(key, val, this.config.getTTL(), TimeUnit.MILLISECONDS, this.config.getMaxIdleTime(), TimeUnit.MILLISECONDS) : this.map.putIfAbsent(key, val);
        return this.fromStoreValue(previous);
    }

    public boolean fastPutIfAbsent(K key, V value) throws CacheException {
        if (!this.allowNullValues && value == null) {
            return false;
        }
        Object val = this.toStoreValue(value);
        if (this.mapCache != null) {
            return this.mapCache.fastPutIfAbsent(key, val, this.config.getTTL(), TimeUnit.MILLISECONDS, this.config.getMaxIdleTime(), TimeUnit.MILLISECONDS);
        }
        return this.map.fastPutIfAbsent(key, val);
    }

    public V remove(K key) throws CacheException {
        Object previous = this.map.remove(key);
        return this.fromStoreValue(previous);
    }

    public long fastRemove(K ... keys) {
        return this.map.fastRemove((Object[])keys);
    }

    public void clear() throws CacheException {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public Set<K> keys() {
        return this.map.readAllKeySet();
    }

    public Collection<V> values() {
        Collection innerValues = this.map.readAllValues();
        ArrayList<V> res = new ArrayList<V>(innerValues.size());
        for (Object val : innerValues) {
            res.add(this.fromStoreValue(val));
        }
        return res;
    }

    protected V fromStoreValue(Object storeValue) {
        if (storeValue instanceof NullValue) {
            return null;
        }
        return (V)storeValue;
    }

    protected Object toStoreValue(V userValue) {
        if (userValue == null) {
            return NullValue.INSTANCE;
        }
        return userValue;
    }

    long getCacheHits() {
        return this.hits.get();
    }

    long getCacheMisses() {
        return this.misses.get();
    }

    private void addCacheHit() {
        this.hits.incrementAndGet();
    }

    private void addCacheMiss() {
        this.misses.incrementAndGet();
    }
}

