/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.snaker.engine.SnakerException;

public class StreamHelper {
    public static final int DEFAULT_CHUNK_SIZE = 1024;
    public static final int BUFFERSIZE = 4096;

    public static InputStream openStream(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream stream = classLoader.getResourceAsStream(resource);
        if (stream == null) {
            stream = StreamHelper.class.getClassLoader().getResourceAsStream(resource);
        }
        return stream;
    }

    public static InputStream getStreamFromString(String text) {
        try {
            byte[] bytes = text.getBytes("UTF-8");
            return new ByteArrayInputStream(bytes);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static InputStream getStreamFromFile(File file) {
        FileInputStream stream = null;
        try {
            if (!file.exists()) {
                throw new SnakerException("file " + file + " doesn't exist");
            }
            if (file.isDirectory()) {
                throw new SnakerException("file " + file + " is a directory");
            }
            stream = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new SnakerException("couldn't access file " + file + ": " + e.getMessage(), e);
        }
        return stream;
    }

    public static InputStream getStreamFromClasspath(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream stream = classLoader.getResourceAsStream(resourceName);
        if (stream == null) {
            stream = StreamHelper.class.getClassLoader().getResourceAsStream(resourceName);
        }
        if (stream == null) {
            throw new SnakerException("resource " + resourceName + " does not exist");
        }
        return stream;
    }

    public static InputStream getStreamFromUrl(URL url) {
        InputStream stream = null;
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            throw new SnakerException("couldn't open URL stream", e);
        }
        return stream;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamHelper.transfer(in, out);
        return out.toByteArray();
    }

    public static long transfer(InputStream in, OutputStream out) throws IOException {
        int count;
        long total = 0L;
        byte[] buffer = new byte[4096];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
            total += (long)count;
        }
        return total;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return StreamHelper.copy(inputStream, outputStream, 1024);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int n;
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return StreamHelper.copy(reader, writer, 1024);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IOException {
        int n;
        char[] buffer = new char[bufferSize];
        long count = 0L;
        while (-1 != (n = reader.read(buffer))) {
            writer.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

