/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.core;

import java.util.List;
import org.snaker.engine.IManagerService;
import org.snaker.engine.access.Page;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.core.AccessService;
import org.snaker.engine.entity.Surrogate;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.DateHelper;
import org.snaker.engine.helper.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerService
extends AccessService
implements IManagerService {
    @Override
    public void saveOrUpdate(Surrogate surrogate) {
        AssertHelper.notNull(surrogate);
        surrogate.setState(STATE_ACTIVE);
        if (StringHelper.isEmpty(surrogate.getId())) {
            surrogate.setId(StringHelper.getPrimaryKey());
            this.access().saveSurrogate(surrogate);
        } else {
            this.access().updateSurrogate(surrogate);
        }
    }

    @Override
    public void deleteSurrogate(String id) {
        Surrogate surrogate = this.getSurrogate(id);
        AssertHelper.notNull(surrogate);
        this.access().deleteSurrogate(surrogate);
    }

    @Override
    public Surrogate getSurrogate(String id) {
        return this.access().getSurrogate(id);
    }

    @Override
    public List<Surrogate> getSurrogate(QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getSurrogate(null, filter);
    }

    @Override
    public List<Surrogate> getSurrogate(Page<Surrogate> page, QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getSurrogate(page, filter);
    }

    @Override
    public String getSurrogate(String operator, String processName) {
        List<Surrogate> surrogates;
        AssertHelper.notEmpty(operator);
        QueryFilter filter = new QueryFilter().setOperator(operator).setOperateTime(DateHelper.getTime());
        if (StringHelper.isNotEmpty(processName)) {
            filter.setName(processName);
        }
        if ((surrogates = this.getSurrogate(filter)) == null || surrogates.isEmpty()) {
            return operator;
        }
        StringBuffer buffer = new StringBuffer(50);
        for (Surrogate surrogate : surrogates) {
            String result = this.getSurrogate(surrogate.getSurrogate(), processName);
            buffer.append(result).append(",");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }
}

