/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.transaction;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.transaction.TransactionStatus;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TransactionInterceptor.class);
    private static final List<String> txMethods = new ArrayList<String>();

    public <T> T getProxy(Class<T> clazz) {
        return (T)Enhancer.create(clazz, (Callback)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = null;
        TransactionStatus status = null;
        if (this.isMatch(method.getName())) {
            if (log.isDebugEnabled()) {
                log.debug("intercept method is[name=" + method.getName() + "]");
            }
            try {
                status = this.getTransaction();
                AssertHelper.notNull(status);
                result = proxy.invokeSuper(obj, args);
                if (!status.isNewTransaction()) return result;
                this.commit(status);
                return result;
            }
            catch (Exception e) {
                this.rollback(status);
                throw new SnakerException(e);
            }
        } else {
            if (!log.isDebugEnabled()) return proxy.invokeSuper(obj, args);
            log.debug("****don't intercept method is[name=" + method.getName() + "]");
            return proxy.invokeSuper(obj, args);
        }
    }

    private boolean isMatch(String methodName) {
        for (String pattern : txMethods) {
            if (!StringHelper.simpleMatch(pattern, methodName)) continue;
            return true;
        }
        return false;
    }

    public abstract void initialize(Object var1);

    protected abstract TransactionStatus getTransaction();

    protected abstract void commit(TransactionStatus var1);

    protected abstract void rollback(TransactionStatus var1);

    static {
        txMethods.add("start*");
        txMethods.add("execute*");
        txMethods.add("finish*");
        txMethods.add("terminate*");
        txMethods.add("take*");
        txMethods.add("create*");
        txMethods.add("save*");
        txMethods.add("delete*");
        txMethods.add("remove*");
        txMethods.add("update*");
        txMethods.add("deploy*");
        txMethods.add("undeploy*");
        txMethods.add("redeploy*");
        txMethods.add("complete*");
        txMethods.add("assign*");
        txMethods.add("withdraw*");
        txMethods.add("reject*");
        txMethods.add("add*");
        txMethods.add("cascade*");
        txMethods.add("get*");
    }
}

