/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.StreamHelper;

public class ScriptRunner {
    private static final Logger log = LoggerFactory.getLogger(ScriptRunner.class);
    private static final String DEFAULT_DELIMITER = ";";
    private Connection connection;
    private boolean autoCommit;
    private String delimiter = ";";

    public ScriptRunner(Connection connection, boolean autoCommit) {
        this.connection = connection;
        this.autoCommit = autoCommit;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void runScript(String resource) throws IOException, SQLException {
        AssertHelper.notNull(resource);
        InputStream input = StreamHelper.getStreamFromClasspath(resource);
        InputStreamReader reader = new InputStreamReader(input, "UTF-8");
        this.runScript(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Reader reader) throws IOException, SQLException {
        AssertHelper.notNull(this.connection);
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (originalAutoCommit != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuffer command = null;
        try {
            LineNumberReader lineReader = new LineNumberReader(reader);
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine;
                if (command == null) {
                    command = new StringBuffer();
                }
                if ((trimmedLine = line.trim()).startsWith("--")) {
                    log.info(trimmedLine);
                    continue;
                }
                if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                if (trimmedLine.equals(this.getDelimiter()) || trimmedLine.endsWith(this.getDelimiter())) {
                    command.append(line.substring(0, line.lastIndexOf(this.getDelimiter())));
                    command.append(" ");
                    Statement statement = conn.createStatement();
                    log.info(command.toString());
                    try {
                        statement.execute(command.toString());
                    }
                    catch (SQLException e) {
                        e.fillInStackTrace();
                        log.error("Error executing: " + command);
                    }
                    if (this.autoCommit && !conn.getAutoCommit()) {
                        conn.commit();
                    }
                    command = null;
                    try {
                        statement.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
            if (!this.autoCommit) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            e.fillInStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }
}

