/*
 * Decompiled with CFR 0.152.
 */
package japicmp.maven;

import japicmp.maven.MavenParameters;
import japicmp.maven.Parameter;
import japicmp.maven.PluginParameters;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class SkipModuleStrategy {
    private final PluginParameters pluginParameters;
    private final MavenParameters mavenParameters;
    private final Log log;

    public SkipModuleStrategy(PluginParameters pluginParameters, MavenParameters mavenParameters, Log log) {
        this.pluginParameters = pluginParameters;
        this.mavenParameters = mavenParameters;
        this.log = log;
    }

    public boolean skip() {
        MavenProject mavenProject = this.mavenParameters.getMavenProject();
        Parameter parameterParam = this.pluginParameters.getParameterParam();
        if (mavenProject != null && parameterParam != null) {
            boolean skipPomModules;
            List<String> packagingSupporteds = parameterParam.getPackagingSupporteds();
            if (packagingSupporteds != null && !packagingSupporteds.isEmpty()) {
                if (!packagingSupporteds.contains(mavenProject.getPackaging())) {
                    this.log.info((CharSequence)"Filtered according to packagingFilter");
                    return true;
                }
            } else {
                this.log.debug((CharSequence)"No packaging support defined, no filtering");
            }
            if ("pom".equals(mavenProject.getPackaging()) && (skipPomModules = parameterParam.getSkipPomModules())) {
                this.log.info((CharSequence)"Skipping execution because packaging of this module is 'pom'.");
                return true;
            }
            String artifactId = mavenProject.getArtifactId();
            if (artifactId != null) {
                List<String> excludeModules = parameterParam.getExcludeModules();
                if (excludeModules != null) {
                    for (String excludeModule : excludeModules) {
                        if (excludeModule == null || !artifactId.matches(excludeModule)) continue;
                        this.log.info((CharSequence)("Skipping module because artifactId matches exclude expression: " + excludeModule));
                        return true;
                    }
                }
                int includeCount = 0;
                List<String> includeModules = parameterParam.getIncludeModules();
                if (includeModules != null) {
                    for (String includeModule : includeModules) {
                        if (includeModule == null) continue;
                        ++includeCount;
                        if (!artifactId.matches(includeModule)) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((CharSequence)("Including module because it is explicitly included: " + includeModule));
                        }
                        return false;
                    }
                }
                if (includeCount > 0) {
                    this.log.info((CharSequence)"Skipping module because explicit includes are defined but artifactId did not match.");
                    return true;
                }
            } else {
                this.log.debug((CharSequence)"Name of maven project is null.");
            }
        }
        return false;
    }
}

