/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.StringUtil;
import com.power.doc.model.CustomField;
import com.power.doc.model.DocJavaField;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JavaFieldUtil {
    public static boolean checkGenerics(List<DocJavaField> fields) {
        for (DocJavaField field : fields) {
            if (field.getJavaField().getType().getFullyQualifiedName().length() != 1) continue;
            return true;
        }
        return false;
    }

    public static void buildCustomField(StringBuilder data0, String typeSimpleName, CustomField customField) {
        Object val = customField.getValue();
        if (null != val) {
            if (DocUtil.javaPrimaryType(typeSimpleName)) {
                data0.append(val).append(",");
            } else {
                data0.append(DocUtil.handleJsonStr(String.valueOf(val))).append(",");
            }
        }
    }

    public static String createMockValue(Map<String, String> paramsComments, String paramName, String typeName, String simpleTypeName) {
        String mockValue = "";
        if (JavaClassValidateUtil.isPrimitive(typeName) && StringUtil.isEmpty((String)(mockValue = Objects.nonNull(mockValue = paramsComments.get(paramName)) && mockValue.contains("|") ? mockValue.substring(mockValue.lastIndexOf("|") + 1) : ""))) {
            mockValue = DocUtil.getValByTypeAndFieldName(simpleTypeName, paramName, Boolean.TRUE);
        }
        return mockValue;
    }

    public static String getParamMaxlength(List<JavaAnnotation> annotations) {
        String maxLength = "";
        for (JavaAnnotation annotation : annotations) {
            String simpleAnnotationName = annotation.getType().getValue();
            AnnotationValue annotationValue = null;
            if ("max".equalsIgnoreCase(simpleAnnotationName)) {
                annotationValue = annotation.getProperty("value");
            }
            if ("size".equalsIgnoreCase(simpleAnnotationName)) {
                annotationValue = annotation.getProperty("max");
            }
            if ("length".equalsIgnoreCase(simpleAnnotationName)) {
                annotationValue = annotation.getProperty("max");
            }
            if (Objects.isNull(annotationValue)) continue;
            maxLength = annotationValue.toString();
        }
        return maxLength;
    }
}

