/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.helper;

import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.CustomField;
import com.power.doc.model.DocJavaField;
import com.power.doc.model.FormData;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FormDataBuildHelper {
    public static List<FormData> getFormData(String className, Map<String, String> registryClasses, int counter, ProjectDocConfigBuilder builder, String pre) {
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("Class name can't be null or empty.");
        }
        ApiConfig apiConfig = builder.getApiConfig();
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        if (counter > apiConfig.getRecursionLimit()) {
            return formDataList;
        }
        if (registryClasses.containsKey(className) && counter > registryClasses.size()) {
            return formDataList;
        }
        registryClasses.put(className, className);
        ++counter;
        boolean skipTransientField = apiConfig.isSkipTransientField();
        boolean requestFieldToUnderline = apiConfig.isRequestFieldToUnderline();
        boolean responseFieldToUnderline = apiConfig.isResponseFieldToUnderline();
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = builder.getJavaProjectBuilder().getClassByName(simpleName);
        List<DocJavaField> fields = JavaClassUtil.getFields(cls, 0, new LinkedHashMap<String, DocJavaField>());
        if (JavaClassValidateUtil.isPrimitive(simpleName)) {
            FormData formData = new FormData();
            formData.setKey(pre);
            formData.setType("text");
            formData.setValue(StringUtil.removeQuotes((String)RandomUtil.randomValueByType((String)className)));
            formDataList.add(formData);
            return formDataList;
        }
        if (JavaClassValidateUtil.isCollection(simpleName) || JavaClassValidateUtil.isArray(simpleName)) {
            String gicName = globGicName[0];
            if (JavaClassValidateUtil.isArray(gicName)) {
                gicName = gicName.substring(0, gicName.indexOf("["));
            }
            if (JavaClassValidateUtil.isPrimitive(gicName)) {
                pre = pre.substring(0, pre.lastIndexOf("."));
            }
            formDataList.addAll(FormDataBuildHelper.getFormData(gicName, registryClasses, counter, builder, pre + "[]"));
        }
        int n = 0;
        for (DocJavaField docField : fields) {
            Map<String, String> tagsMap;
            JavaField field = docField.getJavaField();
            String fieldName = field.getName();
            String subTypeName = docField.getFullyQualifiedName();
            String fieldGicName = docField.getGenericCanonicalName();
            JavaClass javaClass = field.getType();
            if (field.isStatic() || "this$0".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName) || field.isTransient() && skipTransientField) continue;
            if (responseFieldToUnderline || requestFieldToUnderline) {
                fieldName = StringUtil.camelToUnderline((String)fieldName);
            }
            if ((tagsMap = DocUtil.getFieldTagsValue(field, docField)).containsKey("ignore")) continue;
            String typeSimpleName = field.getType().getSimpleName();
            if (JavaClassValidateUtil.isMap(subTypeName)) continue;
            String comment = docField.getComment();
            if (JavaClassValidateUtil.isFile(fieldGicName)) {
                FormData formData = new FormData();
                formData.setKey(pre + fieldName);
                formData.setType("file");
                if (fieldGicName.contains("[]") || fieldGicName.endsWith(">")) {
                    comment = comment + "(array of file)";
                    formData.setType("file");
                }
                formData.setDescription(comment);
                formData.setValue("");
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                String fieldValue = "";
                fieldValue = tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock")) ? tagsMap.get("mock") : DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName());
                CustomField customRequestField = builder.getCustomReqFieldMap().get(fieldName);
                if (Objects.nonNull(customRequestField) && Objects.nonNull(customRequestField.getValue()) && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName())) {
                    fieldValue = String.valueOf(customRequestField.getValue());
                }
                FormData formData = new FormData();
                formData.setKey(pre + fieldName);
                formData.setType("text");
                formData.setValue(StringUtil.removeQuotes((String)fieldValue));
                formData.setDescription(comment);
                formDataList.add(formData);
                continue;
            }
            if (javaClass.isEnum()) {
                Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                    value = tagsMap.get("mock");
                }
                FormData formData = new FormData();
                formData.setKey(pre + fieldName);
                formData.setType("text");
                formData.setValue(StringUtil.removeQuotes((String)String.valueOf(value)));
                formData.setDescription(comment);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isCollection(subTypeName)) {
                String gName;
                String gNameTemp = field.getType().getGenericCanonicalName();
                String[] gNameArr = DocClassUtil.getSimpleGicName(gNameTemp);
                if (gNameArr.length == 0 || JavaClassValidateUtil.isPrimitive(gName = DocClassUtil.getSimpleGicName(gNameTemp)[0]) || simpleName.equals(gName) || gName.equals(simpleName)) continue;
                if (gName.length() == 1) {
                    String gicName;
                    int len = globGicName.length;
                    if (len <= 0 || JavaClassValidateUtil.isPrimitive(gicName = n < len ? globGicName[n] : globGicName[len - 1]) || simpleName.equals(gicName)) continue;
                    formDataList.addAll(FormDataBuildHelper.getFormData(gicName, registryClasses, counter, builder, pre + fieldName + "[0]."));
                    continue;
                }
                formDataList.addAll(FormDataBuildHelper.getFormData(gName, registryClasses, counter, builder, pre + fieldName + "[0]."));
                continue;
            }
            if (subTypeName.length() == 1 || "java.lang.Object".equals(subTypeName)) continue;
            formDataList.addAll(FormDataBuildHelper.getFormData(fieldGicName, registryClasses, counter, builder, pre + fieldName + "."));
        }
        return formDataList;
    }
}

