/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.helper;

import com.power.common.model.EnumDictionary;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDataDictionary;
import com.power.doc.model.ApiParam;
import com.power.doc.model.CustomRespField;
import com.power.doc.model.DocJavaField;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JavaFieldUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ParamsBuildHelper {
    /*
     * WARNING - void declaration
     */
    public static List<ApiParam> buildParams(String className, String pre, int level, String isRequired, Map<String, CustomRespField> responseFieldMap, boolean isResp, Map<String, String> registryClasses, ProjectDocConfigBuilder projectBuilder, List<String> groupClasses, int pid) {
        HashMap<String, String> genericMap = new HashMap<String, String>(10);
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("Class name can't be null or empty.");
        }
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        int nextLevel = level + 1;
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        if (level > apiConfig.getRecursionLimit()) {
            return paramList;
        }
        if (registryClasses.containsKey(className) && level > registryClasses.size()) {
            return paramList;
        }
        boolean skipTransientField = apiConfig.isSkipTransientField();
        boolean isShowJavaType = projectBuilder.getApiConfig().getShowJavaType();
        boolean requestFieldToUnderline = projectBuilder.getApiConfig().isRequestFieldToUnderline();
        boolean responseFieldToUnderline = projectBuilder.getApiConfig().isResponseFieldToUnderline();
        boolean displayActualType = projectBuilder.getApiConfig().isDisplayActualType();
        registryClasses.put(className, className);
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = projectBuilder.getClassByName(simpleName);
        JavaClassUtil.genericParamMap(genericMap, cls, globGicName);
        List<DocJavaField> fields = JavaClassUtil.getFields(cls, 0, new LinkedHashMap<String, DocJavaField>());
        if (JavaClassValidateUtil.isPrimitive(simpleName)) {
            String processedType = isShowJavaType ? simpleName : DocClassUtil.processTypeNameForParams(simpleName.toLowerCase());
            paramList.addAll(ParamsBuildHelper.primitiveReturnRespComment(processedType));
        } else if (JavaClassValidateUtil.isCollection(simpleName) || JavaClassValidateUtil.isArray(simpleName)) {
            if (!JavaClassValidateUtil.isCollection(globGicName[0])) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicName, pre, nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, pid));
            }
        } else if (JavaClassValidateUtil.isMap(simpleName)) {
            if (globGicName.length == 2) {
                paramList.addAll(ParamsBuildHelper.buildParams(globGicName[1], pre, nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, pid));
            }
        } else if ("java.lang.Object".equals(className)) {
            ApiParam param = ApiParam.of().setField(pre + "any object").setType("object").setPid(pid);
            if (StringUtil.isEmpty((String)isRequired)) {
                param.setDesc("any object.").setVersion("-");
            } else {
                param.setDesc("any object.").setRequired(false).setVersion("-");
            }
            paramList.add(param);
        } else {
            boolean isGenerics = JavaFieldUtil.checkGenerics(fields);
            block0: for (DocJavaField docField : fields) {
                String gName;
                String gNameTemp;
                ApiParam param;
                CustomRespField customResponseField;
                String comment;
                JavaField field = docField.getJavaField();
                String fieldName = field.getName();
                String subTypeName = docField.getFullyQualifiedName();
                if (field.isStatic() || "this$0".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName) || field.isTransient() && skipTransientField) continue;
                if (responseFieldToUnderline && isResp || requestFieldToUnderline && !isResp) {
                    fieldName = StringUtil.camelToUnderline((String)fieldName);
                }
                String typeSimpleName = field.getType().getSimpleName();
                String fieldGicName = docField.getGenericCanonicalName();
                List<JavaAnnotation> javaAnnotations = docField.getAnnotations();
                Map<String, String> tagsMap = DocUtil.getFieldTagsValue(field, docField);
                String since = "-";
                if (!isResp) {
                    if (tagsMap.containsKey("ignore")) continue;
                    if (tagsMap.containsKey("since")) {
                        since = tagsMap.get("since");
                    }
                } else if (tagsMap.containsKey("since")) {
                    since = tagsMap.get("since");
                }
                boolean strRequired = false;
                int annotationCounter = 0;
                block1: for (JavaAnnotation annotation : javaAnnotations) {
                    String simpleAnnotationName = annotation.getType().getValue();
                    if ("JsonIgnore".equals(simpleAnnotationName)) continue block0;
                    if ("JSONField".equals(simpleAnnotationName)) {
                        if (null != annotation.getProperty("serialize")) {
                            if (!Boolean.FALSE.toString().equals(annotation.getProperty("serialize").toString())) continue;
                            continue block0;
                        }
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("name").toString());
                        continue;
                    }
                    if ("JsonProperty".equals(simpleAnnotationName)) {
                        if (null == annotation.getProperty("value")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("value").toString());
                        continue;
                    }
                    if ("Null".equals(simpleAnnotationName) && !isResp) {
                        List<String> groupClassList = JavaClassUtil.getParamGroupJavaClass(annotation);
                        for (String string : groupClassList) {
                            if (!groupClasses.contains(string)) continue;
                            strRequired = false;
                            break block1;
                        }
                        continue;
                    }
                    if (!JavaClassValidateUtil.isJSR303Required(simpleAnnotationName) || isResp) continue;
                    ++annotationCounter;
                    boolean hasGroup = false;
                    List<String> groupClassList = JavaClassUtil.getParamGroupJavaClass(annotation);
                    for (String javaClass3 : groupClassList) {
                        if (!groupClasses.contains(javaClass3)) continue;
                        hasGroup = true;
                    }
                    if (hasGroup) {
                        strRequired = true;
                        break;
                    }
                    if (!CollectionUtil.isEmpty(groupClasses)) break;
                    strRequired = true;
                    break;
                }
                if (annotationCounter < 1 && tagsMap.containsKey("required")) {
                    strRequired = true;
                }
                if (StringUtil.isNotEmpty((String)(comment = null != (customResponseField = responseFieldMap.get(field.getName())) && StringUtil.isNotEmpty((String)customResponseField.getDesc()) && simpleName.equals(customResponseField.getOwnerClassName()) ? customResponseField.getDesc() : docField.getComment()))) {
                    comment = DocUtil.replaceNewLineToHtmlBr(comment);
                }
                if (fieldGicName.contains("org.springframework.web.multipart.MultipartFile")) {
                    param = ApiParam.of().setField(pre + fieldName).setType("file").setPid(pid).setId(paramList.size() + pid + 1).setDesc(comment).setRequired(Boolean.valueOf(isRequired)).setVersion(since);
                    paramList.add(param);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                    String fieldValue = "";
                    fieldValue = tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock")) ? tagsMap.get("mock") : DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName());
                    ApiParam param2 = ApiParam.of().setField(pre + fieldName);
                    param2.setPid(pid).setValue(fieldValue);
                    String processedType = isShowJavaType ? typeSimpleName : DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                    param2.setType(processedType);
                    if (StringUtil.isNotEmpty((String)comment)) {
                        ParamsBuildHelper.commonHandleParam(paramList, param2, isRequired, comment, since, strRequired);
                        continue;
                    }
                    ParamsBuildHelper.commonHandleParam(paramList, param2, isRequired, "No comments found.", since, strRequired);
                    continue;
                }
                param = ApiParam.of().setField(pre + fieldName).setPid(pid);
                JavaClass javaClass = projectBuilder.getJavaProjectBuilder().getClassByName(subTypeName);
                if (javaClass.isEnum()) {
                    comment = comment + ParamsBuildHelper.handleEnumComment(javaClass, projectBuilder);
                    param.setType("enum");
                }
                if (JavaClassValidateUtil.isCollection(subTypeName)) {
                    String[] stringArray;
                    String gNameTemp2 = fieldGicName;
                    if (globGicName.length > 0 && "java.util.List".equals(gNameTemp2)) {
                        gNameTemp2 = gNameTemp2 + "<T>";
                    }
                    if ((stringArray = DocClassUtil.getSimpleGicName(gNameTemp2)).length > 0) {
                        String gName2 = DocClassUtil.getSimpleGicName(gNameTemp2)[0];
                        JavaClass javaClass1 = projectBuilder.getJavaProjectBuilder().getClassByName(gName2);
                        comment = comment + ParamsBuildHelper.handleEnumComment(javaClass1, projectBuilder);
                    }
                }
                String appendComment = "";
                if (displayActualType) {
                    if (globGicName.length > 0) {
                        String string;
                        String string2 = string = genericMap.get(subTypeName) != null ? (String)genericMap.get(subTypeName) : globGicName[0];
                        if (!simpleName.equals(string)) {
                            appendComment = " (ActualType: " + JavaClassUtil.getClassSimpleName(string) + ")";
                        }
                    }
                    if (Objects.nonNull(docField.getActualJavaType())) {
                        appendComment = " (ActualType: " + JavaClassUtil.getClassSimpleName(docField.getActualJavaType()) + ")";
                    }
                }
                if (param.getType() == null) {
                    void var41_54;
                    if (typeSimpleName.length() == 1) {
                        String string = DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                    } else {
                        String string = isShowJavaType ? typeSimpleName : DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                    }
                    param.setType((String)var41_54);
                }
                if (!isResp && javaClass.isEnum()) {
                    List list = javaClass.getMethods();
                    int index = 0;
                    block4: for (JavaMethod method : list) {
                        List javaAnnotationList = method.getAnnotations();
                        for (JavaAnnotation annotation : javaAnnotationList) {
                            if (!annotation.getType().getValue().contains("JsonValue")) continue;
                            break block4;
                        }
                        if (CollectionUtil.isEmpty(javaAnnotations) && index < 1) break;
                        ++index;
                    }
                    Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.FALSE);
                    param.setValue(String.valueOf(value));
                    param.setEnumValues(JavaClassUtil.getEnumValues(javaClass));
                    param.setType("enum");
                }
                if (StringUtil.isNotEmpty((String)comment)) {
                    ParamsBuildHelper.commonHandleParam(paramList, param, isRequired, comment + appendComment, since, strRequired);
                } else {
                    ParamsBuildHelper.commonHandleParam(paramList, param, isRequired, "No comments found." + appendComment, since, strRequired);
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < level; ++j) {
                    stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                stringBuilder.append("\u2514\u2500");
                int fieldPid = paramList.size() + pid;
                if (JavaClassValidateUtil.isMap(subTypeName)) {
                    gNameTemp = fieldGicName;
                    if (JavaClassValidateUtil.isMap(gNameTemp)) {
                        ApiParam param1 = ApiParam.of().setField(stringBuilder.toString() + "any object").setId(paramList.size() + 1).setPid(fieldPid).setType("object").setDesc("any object.").setVersion("-");
                        paramList.add(param1);
                        continue;
                    }
                    String valType = DocClassUtil.getMapKeyValueType(gNameTemp)[1];
                    if (JavaClassValidateUtil.isPrimitive(valType)) continue;
                    if (valType.length() == 1) {
                        String gicName = (String)genericMap.get(valType);
                        if (JavaClassValidateUtil.isPrimitive(gicName) || simpleName.equals(gicName)) continue;
                        paramList.addAll(ParamsBuildHelper.buildParams(gicName, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                        continue;
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(valType, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                    continue;
                }
                if (JavaClassValidateUtil.isCollection(subTypeName)) {
                    String[] gNameArr;
                    gNameTemp = fieldGicName;
                    if (globGicName.length > 0 && "java.util.List".equals(gNameTemp)) {
                        gNameTemp = gNameTemp + "<T>";
                    }
                    if ((gNameArr = DocClassUtil.getSimpleGicName(gNameTemp)).length == 0 || JavaClassValidateUtil.isPrimitive(gName = DocClassUtil.getSimpleGicName(gNameTemp)[0]) || simpleName.equals(gName) || gName.equals(simpleName)) continue;
                    if (gName.length() == 1) {
                        String gicName;
                        int len = globGicName.length;
                        if (len < 1 || JavaClassValidateUtil.isPrimitive(gicName = genericMap.get(gName) != null ? (String)genericMap.get(gName) : globGicName[0]) || simpleName.equals(gicName)) continue;
                        paramList.addAll(ParamsBuildHelper.buildParams(gicName, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                        continue;
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(gName, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                    continue;
                }
                if (subTypeName.length() == 1 || "java.lang.Object".equals(subTypeName)) {
                    if (isGenerics && "java.lang.Object".equals(subTypeName)) {
                        ApiParam param1 = ApiParam.of().setField(stringBuilder.toString() + "any object").setId(paramList.size()).setType("object").setDesc("any object.").setVersion("-");
                        paramList.add(param1);
                        continue;
                    }
                    if (simpleName.equals(className)) continue;
                    if (globGicName.length > 0) {
                        String gicName = genericMap.get(subTypeName) != null ? (String)genericMap.get(subTypeName) : globGicName[0];
                        String simple = DocClassUtil.getSimpleName(gicName);
                        if (JavaClassValidateUtil.isPrimitive(simple)) continue;
                        if (gicName.contains("<")) {
                            if (JavaClassValidateUtil.isCollection(simple)) {
                                gName = DocClassUtil.getSimpleGicName(gicName)[0];
                                if (JavaClassValidateUtil.isPrimitive(gName)) continue;
                                paramList.addAll(ParamsBuildHelper.buildParams(gName, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                                continue;
                            }
                            if (JavaClassValidateUtil.isMap(simple)) {
                                String valType = DocClassUtil.getMapKeyValueType(gicName)[1];
                                if (JavaClassValidateUtil.isPrimitive(valType)) continue;
                                paramList.addAll(ParamsBuildHelper.buildParams(valType, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                                continue;
                            }
                            paramList.addAll(ParamsBuildHelper.buildParams(gicName, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                            continue;
                        }
                        paramList.addAll(ParamsBuildHelper.buildParams(gicName, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                        continue;
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(subTypeName, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                    continue;
                }
                if (JavaClassValidateUtil.isArray(subTypeName)) {
                    if (className.equals(fieldGicName = fieldGicName.substring(0, fieldGicName.indexOf("["))) || JavaClassValidateUtil.isPrimitive(fieldGicName)) continue;
                    paramList.addAll(ParamsBuildHelper.buildParams(fieldGicName, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
                    continue;
                }
                if (simpleName.equals(subTypeName) || javaClass.isEnum()) continue;
                paramList.addAll(ParamsBuildHelper.buildParams(fieldGicName, stringBuilder.toString(), nextLevel, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder, groupClasses, fieldPid));
            }
        }
        return paramList;
    }

    public static String dictionaryListComment(ApiDataDictionary dictionary) {
        List<EnumDictionary> enumDataDict = dictionary.getEnumDataDict();
        return enumDataDict.stream().map(apiDataDictionary -> apiDataDictionary.getName() + "-(\"" + apiDataDictionary.getValue() + "\",\"" + apiDataDictionary.getDesc() + "\")").collect(Collectors.joining(","));
    }

    public static List<ApiParam> primitiveReturnRespComment(String typeName) {
        StringBuilder comments = new StringBuilder();
        comments.append("Return ").append(typeName).append(".");
        ApiParam apiParam = ApiParam.of().setField("-").setType(typeName).setDesc(comments.toString()).setVersion("-");
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        paramList.add(apiParam);
        return paramList;
    }

    private static void commonHandleParam(List<ApiParam> paramList, ApiParam param, String isRequired, String comment, String since, boolean strRequired) {
        if (StringUtil.isEmpty((String)isRequired)) {
            param.setDesc(comment).setVersion(since);
        } else {
            param.setDesc(comment).setVersion(since).setRequired(strRequired);
        }
        param.setId(paramList.size() + param.getPid() + 1);
        paramList.add(param);
    }

    private static String handleEnumComment(JavaClass javaClass, ProjectDocConfigBuilder projectBuilder) {
        String comment = "";
        if (!javaClass.isEnum()) {
            return comment;
        }
        String enumComments = javaClass.getComment();
        if (projectBuilder.getApiConfig().getInlineEnum().booleanValue()) {
            ApiDataDictionary dataDictionary = projectBuilder.getApiConfig().getDataDictionary(javaClass.getSimpleName());
            comment = Objects.isNull(dataDictionary) ? comment + "<br/>" + JavaClassUtil.getEnumParams(javaClass) : comment + "[enum:" + ParamsBuildHelper.dictionaryListComment(dataDictionary) + "]";
        } else {
            enumComments = DocUtil.replaceNewLineToHtmlBr(enumComments);
            comment = comment + "<br/>" + JavaClassUtil.getEnumParams(javaClass) + "<br/>";
            if (StringUtil.isNotEmpty((String)enumComments)) {
                comment = comment + "(See: " + enumComments + ")";
            }
            comment = StringUtil.removeQuotes((String)comment);
        }
        return comment;
    }
}

