/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.constants.HighlightStyle;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiConstant;
import com.power.doc.model.ApiObjectReplacement;
import com.power.doc.model.CustomRespField;
import com.power.doc.model.DocJavaField;
import com.power.doc.model.ResponseBodyAdvice;
import com.power.doc.model.SourceCodePath;
import com.power.doc.utils.JavaClassUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class ProjectDocConfigBuilder {
    private static Logger log = Logger.getLogger(ProjectDocConfigBuilder.class.getName());
    private JavaProjectBuilder javaProjectBuilder;
    private Map<String, JavaClass> classFilesMap = new ConcurrentHashMap<String, JavaClass>();
    private Map<String, CustomRespField> customRespFieldMap = new ConcurrentHashMap<String, CustomRespField>();
    private Map<String, String> replaceClassMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> constantsMap = new ConcurrentHashMap<String, String>();
    private String serverUrl;
    private ApiConfig apiConfig;

    public ProjectDocConfigBuilder(ApiConfig apiConfig, JavaProjectBuilder javaProjectBuilder) {
        if (null == apiConfig) {
            throw new NullPointerException("ApiConfig can't be null.");
        }
        this.apiConfig = apiConfig;
        if (Objects.isNull(javaProjectBuilder)) {
            javaProjectBuilder = new JavaProjectBuilder();
        }
        this.serverUrl = StringUtil.isEmpty((String)apiConfig.getServerUrl()) ? "" : apiConfig.getServerUrl();
        this.setHighlightStyle();
        javaProjectBuilder.setEncoding("utf-8");
        this.javaProjectBuilder = javaProjectBuilder;
        try {
            this.loadJavaSource(apiConfig.getSourceCodePaths(), this.javaProjectBuilder);
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
        this.initClassFilesMap();
        this.initCustomResponseFieldsMap(apiConfig);
        this.initReplaceClassMap(apiConfig);
        this.initConstants(apiConfig);
        this.checkResponseBodyAdvice(apiConfig);
    }

    public JavaClass getClassByName(String simpleName) {
        JavaClass cls = this.javaProjectBuilder.getClassByName(simpleName);
        List<DocJavaField> fieldList = JavaClassUtil.getFields(cls, 0, new LinkedHashMap<String, DocJavaField>());
        if (Objects.isNull(cls.getFields()) || fieldList.isEmpty()) {
            cls = this.classFilesMap.get(simpleName);
        } else {
            List classList = cls.getNestedClasses();
            for (JavaClass javaClass : classList) {
                this.classFilesMap.put(javaClass.getFullyQualifiedName(), javaClass);
            }
        }
        return cls;
    }

    private void loadJavaSource(List<SourceCodePath> paths, JavaProjectBuilder builder) {
        if (CollectionUtil.isEmpty(paths)) {
            builder.addSourceTree(new File(DocGlobalConstants.PROJECT_CODE_PATH));
        } else {
            for (SourceCodePath path : paths) {
                String strPath;
                if (null == path || !StringUtil.isNotEmpty((String)(strPath = path.getPath()))) continue;
                strPath = strPath.replace("\\", "/");
                builder.addSourceTree(new File(strPath));
            }
        }
    }

    private void initClassFilesMap() {
        Collection javaClasses = this.javaProjectBuilder.getClasses();
        for (JavaClass cls : javaClasses) {
            this.classFilesMap.put(cls.getFullyQualifiedName(), cls);
        }
    }

    private void initCustomResponseFieldsMap(ApiConfig config) {
        if (CollectionUtil.isNotEmpty(config.getCustomResponseFields())) {
            for (CustomRespField field : config.getCustomResponseFields()) {
                this.customRespFieldMap.put(field.getName(), field);
            }
        }
    }

    private void initReplaceClassMap(ApiConfig config) {
        if (CollectionUtil.isNotEmpty(config.getApiObjectReplacements())) {
            for (ApiObjectReplacement replace : config.getApiObjectReplacements()) {
                this.replaceClassMap.put(replace.getClassName(), replace.getReplacementClassName());
            }
        }
    }

    private void initConstants(ApiConfig config) {
        List<ApiConstant> apiConstants = CollectionUtil.isEmpty(config.getApiConstants()) ? new ArrayList<ApiConstant>() : config.getApiConstants();
        try {
            for (ApiConstant apiConstant : apiConstants) {
                Class<?> clzz = apiConstant.getConstantsClass();
                if (Objects.isNull(clzz)) {
                    if (StringUtil.isEmpty((String)apiConstant.getConstantsClassName())) {
                        throw new RuntimeException("Enum class name can't be null.");
                    }
                    clzz = Class.forName(apiConstant.getConstantsClassName());
                }
                this.constantsMap.putAll(JavaClassUtil.getFinalFieldValue(clzz));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void checkResponseBodyAdvice(ApiConfig config) {
        ResponseBodyAdvice responseBodyAdvice = config.getResponseBodyAdvice();
        if (Objects.nonNull(responseBodyAdvice) && StringUtil.isNotEmpty((String)responseBodyAdvice.getClassName())) {
            if (Objects.nonNull(responseBodyAdvice.getWrapperClass())) {
                return;
            }
            try {
                Class.forName(responseBodyAdvice.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Can't find class " + responseBodyAdvice.getClassName() + " for ResponseBodyAdvice.");
            }
        }
    }

    private void setHighlightStyle() {
        String style = this.apiConfig.getStyle();
        if (HighlightStyle.containsStyle(style)) {
            return;
        }
        Random random = new Random();
        if ("randomLight".equals(style)) {
            style = HighlightStyle.randomLight(random);
            if (HighlightStyle.containsStyle(style)) {
                this.apiConfig.setStyle(style);
            } else {
                this.apiConfig.setStyle("null");
            }
        } else if ("randomDark".equals(style)) {
            this.apiConfig.setStyle(HighlightStyle.randomDark(random));
        } else {
            this.apiConfig.setStyle("null");
        }
    }

    public JavaProjectBuilder getJavaProjectBuilder() {
        return this.javaProjectBuilder;
    }

    public Map<String, JavaClass> getClassFilesMap() {
        return this.classFilesMap;
    }

    public Map<String, CustomRespField> getCustomRespFieldMap() {
        return this.customRespFieldMap;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    public Map<String, String> getReplaceClassMap() {
        return this.replaceClassMap;
    }

    public Map<String, String> getConstantsMap() {
        return this.constantsMap;
    }
}

