/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.file.CopyDirVisitor;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Objects;

public class DirUtil {
    private DirUtil() {
    }

    public static void copy(Path from, Path to) {
        DirUtil.validate(from);
        try {
            Files.walkFileTree(from, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new CopyDirVisitor(from, to));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void validate(Path ... paths) {
        for (Path path : paths) {
            Objects.requireNonNull(path);
            if (Files.isDirectory(path, new LinkOption[0])) continue;
            throw new IllegalArgumentException(String.format("%s is not a directory", path.toString()));
        }
    }
}

