/*
 * Decompiled with CFR 0.152.
 */
package com.github.servanter.net.sf.json.support.spring;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class NetJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private static String CHARSET = "UTF-8";
    private static String TYPE = "application/json";
    private static String CONTENT_TYPE = TYPE + ";charset=" + CHARSET;

    public void setCharset(String charset) {
        CHARSET = charset;
        this.changeContentType();
        this.addMediaType();
    }

    private void addMediaType() {
        this.setSupportedMediaTypes(Collections.singletonList(MediaType.valueOf((String)CONTENT_TYPE)));
    }

    public void changeContentType() {
        CONTENT_TYPE = TYPE + ";charset=" + CHARSET;
    }

    public NetJsonHttpMessageConverter() {
        super(MediaType.valueOf((String)CONTENT_TYPE));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = inputMessage.getBody();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            if (len <= 0) continue;
            baos.write(buf, 0, len);
        }
        JSONObject json = JSONObject.fromObject((Object)new String(buf));
        return JSONObject.toBean((JSONObject)json, clazz);
    }

    protected void writeInternal(Object t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        OutputStream outputStream = outputMessage.getBody();
        outputStream.write(JSONSerializer.toJSON((Object)t).toString().getBytes(CHARSET));
    }
}

