/*
 * Decompiled with CFR 0.152.
 */
package notion.api.v1.http;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import notion.api.v1.http.NotionHttpClient;
import notion.api.v1.http.NotionHttpResponse;
import notion.api.v1.logging.NotionLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005JF\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u0016JF\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u0016JN\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u0016JN\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnotion/api/v1/http/JavaNetHttpClient;", "Lnotion/api/v1/http/NotionHttpClient;", "connectTimeoutMillis", "", "readTimeoutMillis", "(II)V", "client", "Ljava/net/http/HttpClient;", "delete", "Lnotion/api/v1/http/NotionHttpResponse;", "logger", "Lnotion/api/v1/logging/NotionLogger;", "url", "", "query", "", "", "headers", "get", "patchTextBody", "body", "postTextBody", "notion-sdk-jvm-httpclient"})
@SourceDebugExtension(value={"SMAP\nJavaNetHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaNetHttpClient.kt\nnotion/api/v1/http/JavaNetHttpClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,138:1\n215#2,2:139\n215#2,2:141\n215#2,2:143\n215#2,2:145\n*S KotlinDebug\n*F\n+ 1 JavaNetHttpClient.kt\nnotion/api/v1/http/JavaNetHttpClient\n*L\n33#1:139,2\n63#1:141,2\n93#1:143,2\n122#1:145,2\n*E\n"})
public final class JavaNetHttpClient
implements NotionHttpClient {
    private final int readTimeoutMillis;
    @NotNull
    private final HttpClient client;

    public JavaNetHttpClient(int connectTimeoutMillis, int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(connectTimeoutMillis)).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"newBuilder()\n          .\u2026ng()))\n          .build()");
        this.client = httpClient;
    }

    public /* synthetic */ JavaNetHttpClient(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 3000;
        }
        if ((n3 & 2) != 0) {
            n2 = 30000;
        }
        this(n, n2);
    }

    @NotNull
    public NotionHttpResponse get(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, ? extends List<String>> query, @NotNull Map<String, String> headers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        long startTimeMillis = System.currentTimeMillis();
        String fullUrl = this.buildFullUrl(url, this.buildQueryString(query));
        HttpRequest.Builder req = HttpRequest.newBuilder().GET().uri(new URI(fullUrl)).timeout(Duration.ofMillis(this.readTimeoutMillis));
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Map.Entry<String, String> element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl = false;
            String name = object.getKey();
            String value = object.getValue();
            req.header(name, value);
        }
        HttpRequest request = req.build();
        String string = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.method()");
        this.debugLogStart(logger, string, fullUrl, "");
        try {
            HttpResponse<String> resp = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int n = resp.statusCode();
            object = resp.headers().map();
            String string2 = resp.body();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"body()");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map()");
            NotionHttpResponse response = new NotionHttpResponse(n, string2, (Map)object);
            this.debugLogSuccess(logger, startTimeMillis, response);
            return response;
        }
        catch (Exception e) {
            this.warnLogFailure(logger, e);
            throw e;
        }
    }

    @NotNull
    public NotionHttpResponse postTextBody(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, ? extends List<String>> query, @NotNull String body, @NotNull Map<String, String> headers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        long startTimeMillis = System.currentTimeMillis();
        String fullUrl = this.buildFullUrl(url, this.buildQueryString(query));
        HttpRequest.Builder req = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body, Charsets.UTF_8)).uri(new URI(fullUrl)).timeout(Duration.ofMillis(this.readTimeoutMillis));
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Map.Entry<String, String> element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl = false;
            String name = object.getKey();
            String value = object.getValue();
            req.header(name, value);
        }
        HttpRequest request = req.build();
        String string = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.method()");
        this.debugLogStart(logger, string, fullUrl, body);
        try {
            HttpResponse<String> resp = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int n = resp.statusCode();
            object = resp.headers().map();
            String string2 = resp.body();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"body()");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map()");
            NotionHttpResponse response = new NotionHttpResponse(n, string2, (Map)object);
            this.debugLogSuccess(logger, startTimeMillis, response);
            return response;
        }
        catch (Exception e) {
            this.warnLogFailure(logger, e);
            throw e;
        }
    }

    @NotNull
    public NotionHttpResponse patchTextBody(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, ? extends List<String>> query, @NotNull String body, @NotNull Map<String, String> headers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        long startTimeMillis = System.currentTimeMillis();
        String fullUrl = this.buildFullUrl(url, this.buildQueryString(query));
        HttpRequest.Builder req = HttpRequest.newBuilder().method("PATCH", HttpRequest.BodyPublishers.ofString(body, Charsets.UTF_8)).uri(new URI(this.buildFullUrl(url, this.buildQueryString(query)))).timeout(Duration.ofMillis(this.readTimeoutMillis));
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Map.Entry<String, String> element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl = false;
            String name = object.getKey();
            String value = object.getValue();
            req.header(name, value);
        }
        HttpRequest request = req.build();
        String string = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.method()");
        this.debugLogStart(logger, string, fullUrl, body);
        try {
            HttpResponse<String> resp = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int n = resp.statusCode();
            object = resp.headers().map();
            String string2 = resp.body();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"body()");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map()");
            NotionHttpResponse response = new NotionHttpResponse(n, string2, (Map)object);
            this.debugLogSuccess(logger, startTimeMillis, response);
            return response;
        }
        catch (Exception e) {
            this.warnLogFailure(logger, e);
            throw e;
        }
    }

    @NotNull
    public NotionHttpResponse delete(@NotNull NotionLogger logger, @NotNull String url, @NotNull Map<String, ? extends List<String>> query, @NotNull Map<String, String> headers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        long startTimeMillis = System.currentTimeMillis();
        String fullUrl = this.buildFullUrl(url, this.buildQueryString(query));
        HttpRequest.Builder req = HttpRequest.newBuilder().DELETE().uri(new URI(fullUrl)).timeout(Duration.ofMillis(this.readTimeoutMillis));
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Map.Entry<String, String> element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl = false;
            String name = object.getKey();
            String value = object.getValue();
            req.header(name, value);
        }
        HttpRequest request = req.build();
        String string = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.method()");
        this.debugLogStart(logger, string, fullUrl, "");
        try {
            HttpResponse<String> resp = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int n = resp.statusCode();
            object = resp.headers().map();
            String string2 = resp.body();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"body()");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map()");
            NotionHttpResponse response = new NotionHttpResponse(n, string2, (Map)object);
            this.debugLogSuccess(logger, startTimeMillis, response);
            return response;
        }
        catch (Exception e) {
            this.warnLogFailure(logger, e);
            throw e;
        }
    }

    @NotNull
    public String buildFullUrl(@NotNull String url, @NotNull String q) {
        return NotionHttpClient.DefaultImpls.buildFullUrl((NotionHttpClient)this, (String)url, (String)q);
    }

    @NotNull
    public String buildQueryString(@NotNull Map<String, ? extends List<String>> query) {
        return NotionHttpClient.DefaultImpls.buildQueryString((NotionHttpClient)this, query);
    }

    public void close() {
        NotionHttpClient.DefaultImpls.close((NotionHttpClient)this);
    }

    public void debugLogStart(@NotNull NotionLogger logger, @NotNull String method, @NotNull String fullUrl, @Nullable String body) {
        NotionHttpClient.DefaultImpls.debugLogStart((NotionHttpClient)this, (NotionLogger)logger, (String)method, (String)fullUrl, (String)body);
    }

    public void debugLogSuccess(@NotNull NotionLogger logger, long startTimeMillis, @NotNull NotionHttpResponse response) {
        NotionHttpClient.DefaultImpls.debugLogSuccess((NotionHttpClient)this, (NotionLogger)logger, (long)startTimeMillis, (NotionHttpResponse)response);
    }

    @NotNull
    public String urlEncode(@NotNull String value) {
        return NotionHttpClient.DefaultImpls.urlEncode((NotionHttpClient)this, (String)value);
    }

    public void warnLogFailure(@NotNull NotionLogger logger, @NotNull Exception e) {
        NotionHttpClient.DefaultImpls.warnLogFailure((NotionHttpClient)this, (NotionLogger)logger, (Exception)e);
    }

    public JavaNetHttpClient() {
        this(0, 0, 3, null);
    }
}

